.module/RAM/ABS=0       ASP;
{------------------------------------------------------------------------------
                      EZKIT Audio Signal Procesor
 
                  Copyright (C) Johan B. Forrer, 1996 
                        26553 Priceview Drive
                          Monroe, OR 97456   

                            July 1996

------------------------------------------------------------------------------
                         Acknowledgements:
------------------------------------------------------------------------------
 1) Adrian Nash, G4ZHZ                      --- Digital BFO, sine functions
 2) Analog Devices, EZKIT software examples --- UART
 3) Dave Hershberger, W9GR                  --- Denoising background
------------------------------------------------------------------------------

                             IMPORTANT!!!
  CODEC uses registers I5,L5,I6,L6, and M5 in Autobuffer mode. Leave intact!
-----------------------------------------------------------------------------}

.include    <dsp.inc>;

.GLOBAL rx_buf, tx_buf, sigout_L, sigout_R;
.EXTERNAL input_isr, input_init, bfo_init, bfo_freq;
.EXTERNAL LMS_init, LMS, Denoise_switch, Autonotch_switch;
.EXTERNAL CW_switch;

.include <uart.inc>;

{----------------------------------------------------------------------------}
{                     Variables						     }
{----------------------------------------------------------------------------}

.var/dm/ram/circ	rx_buf[3];      /* Status + L data + R data */
.var/dm/ram/circ        tx_buf[3];      /* Cmd + L data + R data    */
.var/dm/ram/circ        init_cmds[13];

.VAR/DM/RAM  		sigout_L;
.VAR/DM/RAM  		sigout_R;

.var/dm                 stat_flag;		{ controls CODEC init sequence }

.init tx_buf:   0xc000, 0x0000, 0x0000; /* Initially set MCE        */

.init init_cmds:
        0xc004,     {
                        Left input control reg
                        b7-6: 0=left line 1   =====>
                              1=left aux 1
                              2=left line 2
                              3=left line 1 post-mixed loopback
                        b5-4: res
                        b3-0: left input gain x 1.5 dB
                    }
        0xc104,     {
                        Right input control reg
                        b7-6: 0=right line 1  =====>
                              1=right aux 1
                              2=right line 2
                              3=right line 1 post-mixed loopback
                        b5-4: res
                        b3-0: right input gain x 1.5 dB
                    }
        0xc288,     {
                        left aux 1 control reg
                        b7  : 1=left aux 1 mute	 =====>
                        b6-5: res
                        b4-0: gain/atten x 1.5, 08= 0dB, 00= 12dB
                    }
        0xc388,     {
                        right aux 1 control reg
                        b7  : 1=right aux 1 mute ======>
                        b6-5: res		 
                        b4-0: gain/atten x 1.5, 08= 0dB, 00= 12dB
                    }
        0xc488,     {
                        left aux 2 control reg
                        b7  : 1=left aux 2 mute	 ======>
                        b6-5: res
                        b4-0: gain/atten x 1.5, 08= 0dB, 00= 12dB
                    }
        0xc588,     {
                        right aux 2 control reg
                        b7  : 1=right aux 2 mute ======>
                        b6-5: res
                        b4-0: gain/atten x 1.5, 08= 0dB, 00= 12dB
                    }
        0xc680,     {
                        left DAC control reg
                        b7  : 1=left DAC mute
                        b6  : res
                        b5-0: attenuation x 1.5 dB
                    }
        0xc780,     {
                        right DAC control reg
                        b7  : 1=right DAC mute
                        b6  : res
                        b5-0: attenuation x 1.5 dB
                    }
        0xc855,     {	1100 1000 0101 0000 (16-bit, stereo, 18.9 kSPS)
                        data format register
                        b7  : res
                        b5-6: 0=8-bit unsigned linear PCM
                              1=8-bit u-law companded
                              2=16-bit signed linear PCM
                              3=8-bit A-law companded
                        b4  : 0=mono, 1=stereo
                        b0-3: 0=  8.
                              1=  5.5125
                              2= 16.
                              3= 11.025
                              4= 27.42857
                              5= 18.9
                              6= 32.
                              7= 22.05
                              8=   .
                              9= 37.8
                              a=   .
                              b= 44.1
                              c= 48.
                              d= 33.075
                              e=  9.6
                              f=  6.615
                       (b0) : 0=XTAL1 24.576 MHz; 1=XTAL2 16.9344 MHz
                    }
        0xc909,     {
                        interface configuration reg
                        b7-4: res
                        b3  : 1=autocalibrate
                        b2-1: res
                        b0  : 1=playback enabled
                    }
        0xca00,     {
                        pin control reg
                        b7  : logic state of pin XCTL1
                        b6  : logic state of pin XCTL0
                        b5  : master - 1=tri-state CLKOUT
                              slave  - x=tri-state CLKOUT
                        b4-0: res
                    }
        0xcc40,     {
                        miscellaneous information reg
                        b7  : 1=16 slots per frame, 0=32 slots per frame
                        b6  : 1=2-wire system, 0=1-wire system
                        b5-0: res
                    }
        0xcd00;     {
                        digital mix control reg
                        b7-2: attenuation x 1.5 dB
                        b1  : res
                        b0  : 1=digital mix enabled
                    }


{----------------------------------------------------------------------------}
{            Interrupt vector table					     }
{----------------------------------------------------------------------------}
        jump start;  rti; rti; rti;     {00: reset }
        rti;         rti; rti; rti;     {04: IRQ2 }
        rti;         rti; rti; rti;     {08: IRQL1 }
        rti;         rti; rti; rti;     {0c: IRQL0 }
        ar = dm(stat_flag);             {10: SPORT0 tx }
        ar = pass ar;			{ used for initializing CODEC }
        if eq rti;			{ ....                        }                                         
        jump next_cmd;
        jump input_isr;             	{14: SPORT0 rx }
                     rti; rti; rti;
        jump irqe;   rti; rti; rti;     {18: IRQE }
        rti;         rti; rti; rti;     {1c: BDMA }
        jump irq1isr;        rti; rti; rti;     {20: SPORT1 tx or IRQ1 }
        rti;                 rti; rti; rti;     {24: SPORT1 rx or IRQ0 }
        jump process_a_bit;  rti; rti; rti;     {28: timer }
        rti;                 rti; rti; rti;     {2c: power down }

{----------------------------------------------------------------------------}
{       ADSP 2181 intialization						     }
{----------------------------------------------------------------------------}
start:
        ax0 = b#0000100000000000;	{  Shut down sport 0 }
	dm (System_Control_Reg) = ax0;

        i5 = ^rx_buf;
        l5 = %rx_buf;
        i6 = ^tx_buf;
        l6 = %tx_buf;
        i3 = ^init_cmds;
        l3 = %init_cmds;

        m1 = 1;
        m5 = 1;


{================== S E R I A L   P O R T   #0   S T U F F ==================}

        ax0 = b#0000110011010111;   dm (SPORT0_Autobuf) = ax0;	{ TEST!!! }
            {   |||!|-/!/|-/|/|+- receive autobuffering 0=off, 1=on
                |||!|  ! |  | +-- transmit autobuffering 0=off, 1=on
                |||!|  ! |  +---- | receive m?
                |||!|  ! |        | m5
                |||!|  ! +------- ! receive i?
                |||!|  !          ! i0
                |||!|  !          !
                |||!|  +========= | transmit m?
                |||!|             | m6
                |||!+------------ ! transmit i?
                |||!              ! i1
                |||!              !
                |||+============= | BIASRND MAC biased rounding control bit
                ||+-------------- 0
                |+--------------- | CLKODIS CLKOUT disable control bit
                +---------------- 0
            }

        ax0 = 0;    dm (SPORT0_RFSDIV) = ax0;              {   RFSDIV = SCLK Hz/RFS Hz - 1 }
        ax0 = 0;    dm (SPORT0_SCLKDIV) = ax0;		   {   SCLK = CLKOUT / (2  (SCLKDIV + 1) }

        ax0 = b#1000011000001111;   dm (SPORT0_Control_Reg) = ax0;
            {   multichannel
                ||+--/|!||+/+---/ | number of bit per word - 1
                |||   |!|||       | = 15
                |||   |!|||       |
                |||   |!|||       |
                |||   |!||+====== ! 0=right just, 0-fill; 1=right just, signed
                |||   |!||        ! 2=compand u-law; 3=compand A-law
                |||   |!|+------- receive framing logic 0=pos, 1=neg
                |||   |!+-------- transmit data valid logic 0=pos, 1=neg
                |||   |+========= RFS 0=ext, 1=int
                |||   +---------- multichannel length 0=24, 1=32 words
                ||+-------------- | frame sync to occur this number of clock
                ||                | cycle before first bit
                ||                |
                ||                |
                |+--------------- ISCLK 0=ext, 1=int
                +---------------- multichannel 0=disable, 1=enable
            }
            {   non-multichannel
                |||!|||!|||!+---/ | number of bit per word - 1
                |||!|||!|||!      | = 15
                |||!|||!|||!      |
                |||!|||!|||!      |
                |||!|||!|||+===== ! 0=right just, 0-fill; 1=right just, signed
                |||!|||!||+------ ! 2=compand u-law; 3=compand A-law
                |||!|||!|+------- receive framing logic 0=pos, 1=neg
                |||!|||!+-------- transmit framing logic 0=pos, 1=neg
                |||!|||+========= RFS 0=ext, 1=int
                |||!||+---------- TFS 0=ext, 1=int
                |||!|+----------- TFS width 0=FS before data, 1=FS in sync
                |||!+------------ TFS 0=no, 1=required
                |||+============= RFS width 0=FS before data, 1=FS in sync
                ||+-------------- RFS 0=no, 1=required
                |+--------------- ISCLK 0=ext, 1=int
                +---------------- multichannel 0=disable, 1=enable
            }


        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels0) = ax0;
            {   ^15          00^   transmit word enables: channel # == bit # }
        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels1) = ax0;
            {   ^31          16^   transmit word enables: channel # == bit # }
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels0) = ax0;
            {   ^15          00^   receive word enables: channel # == bit # }
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels1) = ax0;
            {   ^31          16^   receive word enables: channel # == bit # }


{============== S Y S T E M   A N D   M E M O R Y   S T U F F ==============}
        ax0 = b#0000111111111111;   dm (DM_Wait_Reg) = ax0;
            {   |+-/+-/+-/+-/+-/- ! IOWAIT0
                ||  |  !  |       !
                ||  |  !  |       !
                ||  |  !  +------ | IOWAIT1
                ||  |  !          |
                ||  |  !          |
                ||  |  +--------- ! IOWAIT2
                ||  |             !
                ||  |             !
                ||  +------------ | IOWAIT3
                ||                |
                ||                |
                |+=============== ! DWAIT
                |                 !
                |                 !
                +---------------- 0
            }

        ax0 = b#0001000000000000;   dm (System_Control_Reg) = ax0;
            {   +-/!||+-----/+-/- | program memory wait states
                |  !|||           | 0
                |  !|||           |
                |  !||+---------- 0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !|+----------- SPORT1 1=serial port, 0=FI, FO, IRQ0, IRQ1,..
                |  !+------------ SPORT1 1=enabled, 0=disabled
                |  +============= SPORT0 1=enabled, 0=disabled
                +---------------- 0
                                  0
                                  0
            }


        ifc = b#00000011111111;         { clear pending interrupt }
        nop;


        icntl = b#00000;
            {     ||||+- | IRQ0: 0=level, 1=edge
                  |||+-- | IRQ1: 0=level, 1=edge
                  ||+--- | IRQ2: 0=level, 1=edge
                  |+---- 0
                  |----- | IRQ nesting: 0=disabled, 1=enabled
            }


        mstat = b#1000000;
            {     ||||||+- | Data register bank select
                  |||||+-- | FFT bit reverse mode (DAG1)
                  ||||+--- | ALU overflow latch mode, 1=sticky
                  |||+---- | AR saturation mode, 1=saturate, 0=wrap
                  ||+----- | MAC result, 0=fractional, 1=integer
                  |+------ | timer enable
                  +------- | GO MODE
            }

{----------------------------------------------------------------------------}
{                  ADSP 1847 Codec intialization			     }
{----------------------------------------------------------------------------}

        ax0 = 1;   		{ Clear flag so CODEC init sequence can run  }
        dm(stat_flag) = ax0;

        imask = b#0001000000;	{  Enable transmit interrupt }
            {     |||||||||+ | timer
                  ||||||||+- | SPORT1 rec or IRQ0
                  |||||||+-- | SPORT1 trx or IRQ1
                  ||||||+--- | BDMA
                  |||||+---- | IRQE
                  ||||+----- | SPORT0 rec
                  |||+------ | SPORT0 trx
                  ||+------- | IRQL0
                  |+-------- | IRQL1
                  +--------- | IRQ2
            }

        ena ints;

        ax0 = dm (i6, m5);          { start interrupt, reading RIGHT channel }
        tx0 = ax0;

check_init:
        ax0 = dm (stat_flag);       { wait for entire init }
        af = pass ax0;              { buffer to be sent to }
        if ne jump check_init;      { the codec            }

        ay0 = 2;
check_aci1:
        ax0 = dm (rx_buf);          { once initialized, wait for codec }
        ar = ax0 and ay0;           { to come out of autocalibration }
        if eq jump check_aci1;      { wait for bit set }

check_aci2:
        ax0 = dm (rx_buf);          { wait for bit clear }
        ar = ax0 and ay0;
        if ne jump check_aci2;
        idle;

        ay0 = 0xbf3f;               { unmute left DAC }
        ax0 = dm (init_cmds + 6);
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;

        ax0 = dm (init_cmds + 7);   { unmute right DAC }
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;

	dis ints;

        ifc = b#00000011111111;     { clear any pending interrupt }
        nop;

        imask = b#0000110000;       { enable rx0 interrupt }
            {     |||||||||+ | timer
                  ||||||||+- | SPORT1 rec or IRQ0
                  |||||||+-- | SPORT1 trx or IRQ1
                  ||||||+--- | BDMA
                  |||||+---- | IRQE
                  ||||+----- | SPORT0 rec
                  |||+------ | SPORT0 trx
                  ||+------- | IRQL0
                  |+-------- | IRQL1
                  +--------- | IRQ2
            }

{----------------------------------------------------------------------------}
{                  User program initialization                               }
{----------------------------------------------------------------------------}
	call input_init;		{ pointers and initial values }
	call bfo_init;

	call LMS_init;

        call init_uart;            { intialize uart routine }
        call turn_rx_on;           { turn on uart }
{----------------------------------------------------------------------------}

        ena ints;

{----------------------------------------------------------------------------}
{   Idle loop. Nothing really happens here. Processing happen in CODEC ISR   }
{----------------------------------------------------------------------------}
again:  
	ax1=0x3D;		{ prompt => }
        call out_char_ax1; 
	ax1=0x3E;
        call out_char_ax1; 

	idle;

        call get_char_ax1; 	{ get character and echo it back }
        call out_char_ax1; 

{----------------------------------------------------------------------------}
{  Command                  Action			                     }
{----------------------------------------------------------------------------}
{     +		Increase BFO frequency (fine   -  1 Hz steps)                }
{     -		Decrease BFO frequency (fine   -  1 Hz steps)                }
{     )		Increase BFO frequency (meduim - 10 Hz steps)                }
{     (		Decrease BFO frequency (meduim - 10 Hz steps)                }
{     >		Increase BFO frequency (coarse - 10 Hz steps)                }
{     <		Decrease BFO frequency (coarse - 10 Hz steps)                }
{     c         Clear BFO frequency (0 Hz)                                   }
{     d         Toggle denoiser    in/out                                    }
{     n         Toggle autonotcher in/out                                    }
{     x         Enable 100 Hz CW filter                                      }
{     y         Enable 500 Hz CW filter                                      }
{     r         Reset: BFO, denoiser, autonotch, CW                          }
{----------------------------------------------------------------------------}
        ay1 = 0x64;  			{ d }
        none = ax1 - ay1;
        if eq jump toggle_denoiser;

        ay1 = 0x6E;  			{ n }
        none = ax1 - ay1;
        if eq jump toggle_notch;
	
        ay1 = 0x63;  			{ c }
        none = ax1 - ay1;
        if eq jump BFO_clear;

        ay1 = 0x78;  			{ x }
        none = ax1 - ay1;
        if eq jump CW_100;

        ay1 = 0x79;  			{ y }
        none = ax1 - ay1;
        if eq jump CW_500;

        ay1 = 0x72;  			{ r }
        none = ax1 - ay1;
        if eq jump resets;

        ay1 = 0x2B;  			{ +       1 Hz }
        none = ax1 - ay1;
        if eq jump BFO_up;

        ay1 = 0x2D;  			{ -       1 Hz }
        none = ax1 - ay1;
        if eq jump BFO_dn;

        ay1 = 0x29;  			{ )      10 Hz }
        none = ax1 - ay1;
        if eq jump BFO_med_up;

        ay1 = 0x28;  			{ (      10 Hz }
        none = ax1 - ay1;
        if eq jump BFO_med_dn;

        ay1 = 0x3E;  			{ >     100 Hz }
        none = ax1 - ay1;
        if eq jump BFO_coarse_up;

        ay1 = 0x3C;  			{ <     100 Hz }
        none = ax1 - ay1;
        if eq jump BFO_coarse_dn;

command_err:
	ax1=0x20;			{ invalid command }
        call out_char_ax1; 
	ax1=0x3F;			{ ? }
        call out_char_ax1; 
	ax1=0x0D;
        call out_char_ax1; 
	ax1=0x0A;
        call out_char_ax1; 
	jump again;

command_ok:
	ax1=0x20;			{ valid command }
        call out_char_ax1; 
	ax1=0x4F;
        call out_char_ax1; 
	ax1=0x4B;
        call out_char_ax1; 
	ax1=0x0D;
        call out_char_ax1; 
	ax1=0x0A;
        call out_char_ax1; 
	jump again;

{----------------------------------------------------------------------------}
{                         BFO control commands  			     }
{----------------------------------------------------------------------------}
BFO_clear:
	ar=0;
	dm(bfo_freq)=ar;
	jump command_ok;
BFO_up:					{ fine }
	ay0=dm(bfo_freq);	        
	ar=ay0+1;
	jump BFO_update;
BFO_dn:					{ fine }
	ay0=dm(bfo_freq);
	ar=ay0-1;
	jump BFO_update;
BFO_med_up:				{ meduim }
	ax0=dm(bfo_freq);
	ay0=10;
	ar=ax0+ay0;
	jump BFO_update;
BFO_med_dn:				{ medium }
	ax0=dm(bfo_freq);
	ay0=10;
	ar=ax0-ay0;
	jump BFO_update;
BFO_coarse_up:				{ coarse }
	ax0=dm(bfo_freq);
	ay0=100;
	ar=ax0+ay0;
	jump BFO_update;
BFO_coarse_dn:				{ coarse }
	ax0=dm(bfo_freq);
	ay0=100;
	ar=ax0-ay0;
	jump BFO_update;

BFO_update:
	dm(bfo_freq)=ar;		{ frequency is OK }
	jump command_ok;
{----------------------------------------------------------------------------}
{                         LMS control commands  			     }
{----------------------------------------------------------------------------}
toggle_denoiser:
	ar=dm(Denoise_switch);
	ay0=0xFFFF;
	ar=ar XOR ay0;
	dm(Denoise_switch)=ar;
	jump command_ok;

toggle_notch:
	ar=dm(Autonotch_switch);
	ay0=0xFFFF;
	ar=ar XOR ay0;
	dm(Autonotch_switch)=ar;
	jump command_ok;

{----------------------------------------------------------------------------}
{                         CW filter control commands  			     }
{----------------------------------------------------------------------------}
CW_500:
	ar=500;      
	dm(CW_switch)=ar;
	jump command_ok;
CW_100:
	ar=100;      
	dm(CW_switch)=ar;
	jump command_ok;

resets:
	ar=0;
	dm(CW_switch)=ar;
	dm(bfo_freq)=ar;
	dm(Denoise_switch)=ar;
	dm(Autonotch_switch)=ar;
	jump command_ok;
	
{----------------------------------------------------------------------------}
{      Transmit interrupt used for Codec initialization			     }
{----------------------------------------------------------------------------}
next_cmd:
        ena sec_reg;
        ax0 = dm (i3, m1);          { fetch next control word and }
        dm (tx_buf) = ax0;          { place in transmit slot 0    }
        ax0 = i3;
        ay0 = ^init_cmds;
        ar = ax0 - ay0;
        if gt rti;                  { rti if more control words still waiting }
        ax0 = 0xaf00;               { else set done flag and }
        dm (tx_buf) = ax0;          { remove MCE if done initialization }
        ax0 = 0;
        dm (stat_flag) = ax0;       { reset status flag }
        rti;

{----------------------------------------------------------------------------}
{      Dummy INTE switch interrupt handler				     }
{----------------------------------------------------------------------------}
irqe:   toggle fl1;
        rti;
{----------------------------------------------------------------------------}


{----------------------------------------------------------------------------}
{   A high to low transition on flag_in signifies the start bit; it also     }
{   triggers IRQ1 ISR which then turn on timer if the timer is off.  This is }
{   at to most 1/3 bit period too late but we should still catch the byte.   }
{----------------------------------------------------------------------------}
irq1isr:
        pop sts;
        ena timer;              { start timer now }
        rts;                    { note rts }
{----------------------------------------------------------------------------}
.endmod;
