/*ldir/lread
   Program to read Linux extended 2 filesystems under DOS

   Module UNIXdisk.c
   Low level harddisk partition table and harddisk data read

   This is the operating system specific file for UNIX systems,
   hacked by Richard Zidlicky.

   Copyright information and copying policy see file README.TXT

   History see file MAIN.C
 */

/* ignore LBA/CHS for now - assume "partition special file" */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include "ldir.h"
#include "ext2.h"
#include "proto.h"

extern char *disk_name;
extern int disk_fd;
extern FILE *STDOUT, *STDERR;

#define  PRINT_PARTITION_TABLE    for (k=0;k<4;k++)     				\
					 { printf("Entry %i: ",k);          	      	\
					   printf("%X %X %X %X %X %X %X %X %lX %lX\n",	\
                                            		pTEntry[k]->bootIndicator,  	\
                                                        pTEntry[k]->startHead,       	\
                                                        pTEntry[k]->startSector,      	\
                                                        pTEntry[k]->startCylinder,     	\
                                                        pTEntry[k]->system,          	\
                                                        pTEntry[k]->endHead,          	\
                                                        pTEntry[k]->endSector,         	\
                                                        pTEntry[k]->endCylinder,      	\
                                                        pTEntry[k]->leadSectors,      	\
                                                        pTEntry[k]->numSectors); }	\
				  printf("Partition Code %x%x\n",buf[510],buf[511]);

/* globals */
unsigned int HEADS;						/*your harddisk's # of heads               ) drive's */
unsigned int SECTORS;						/*                # of sectors per cylinder) geometry */
unsigned int CYLINDERS;						/*                # of cylinders           )         */
unsigned long start;						/*logical block address(LBA) of your Linux partition */
unsigned long num_sect;						/*total # of sectors of your Linux partition */
extern unsigned int disk_no;					/*DOS' disk #, eg. 0x80=first harddisk */
extern unsigned int part_no;					/*# of your Linux partition */
extern char ext2_disk[32];					/*your linux partition name, eg. /dev/hda5 */
extern enum
{
    LDIR, LREAD, LWRITE, LTEST
}
modus;

extern void *MALLOC(size_t size);
extern void FREE(void *block);


/*########################################################################## */


/*Convert Logical Block Number (LBA) adress to Cylinder-Head-Sector (CHS) address
   DOS and Linux software doesn't care about heads, sectors, cylinders, ie.
   your harddisk's hardware details and therefore works with LBA, but if you
   want to access your harddisk via the BIOS, you have to call the BIOS rou-
   tines with CHS addresses.
 */
void convert(unsigned long x, unsigned short *head, unsigned short *track, \
	     unsigned short *sector, unsigned short *offset)
{
    unsigned long logicsect, absolsect;

#ifdef DEBUG_READDISK
    printf("--------Executing 'convert'----------------\n");
#endif
    logicsect = x >> 9;						/*divide by 512= harddisk sector size */
    *offset = x & 0x1FF;					/*modulo 512 */
    absolsect = logicsect + start;

    *track = absolsect / (SECTORS * HEADS);
    *head = (absolsect / SECTORS) % HEADS;
    *sector = (absolsect % SECTORS) + 1;

#ifdef DEBUG_READDISK
    printf("Beginning at sect=%ld...\n", start);
    printf("byte=%4ld logic: %-4ld absol: %-4ld head: %-3d track: %-4d sect: %-4d  offset: %-d\n",
	   x, logicsect, absolsect, *head, *track, *sector, *offset);
#endif
    if (absolsect > start + num_sect)
    {
	fprintf(STDERR, "You cannot access ABOVE the Linux partition.\n");
	exit(-1);
    }
}

/*This procedure looks for your Linux partition.
   You have to specify the disk to search in ldir.h or via the -s command
   line switch, specification is done in Linux 'style', your specification is
   converted into a DOS 'style' specification in global variables disk_no and
   part_no, eg.:

   /dev/hdaX           first harddisk        disk_no=0x80
   /dev/hdbX           second harddisk               0x81
   /dev/fd0            first floppy disk             0x00
   /dev/fd1            second floppy disk            0x01

   If you do not specify a partition number, i.e. if X is a space, the procedure
   will search the four entrys of the partition table for a primary Linux Ext2
   partition, if it finds one, it will use it. If it does not find a primary
   Linux Ext2 partition, it searches for a DOS extended partition, read's the
   DOS extended partition's table and searches it for a Linux Ext2 partition.
   As DOS extended partitions may contain an unlimited number of 'logical drives',
   this search is recursively until we find a Linux Ext2 partition or until we
   reach the end of the tables.

   If you additionally specify a partition number, i.e. set X to 5, for each
   Linux partition we find we also check, if it is the specified partition num-
   ber. If not, we continue the search of the partition table. The partition
   number is transfered to the procedure via global variable part_no.
 */

int examine_drive(void)
{
    struct stat sbuf;
#if 0
    int i, j = 0, k, kfound, p = 1, ptemp[8];
    static unsigned char *buf, *pTyp;
    char found = NONE;
    partitionTableEntry *pTEntry[4];

    unsigned int head = 0, cyl = 0, sect = 1;
    unsigned int first_head, first_sect, first_cyl;

#ifdef DEBUG_READDISK
    unsigned int boot, end_head, end_sect, end_cyl;
    unsigned int system;

    printf("--------Executing 'examine drive'----------------\n");
#endif
#endif
    /* fake version, don't bother with partitions now */

    disk_fd = open(disk_name, O_RDWR);				/* !!! */
    if (disk_fd < 0)
    {
	perror("could not open partition special file:");
	fprintf(STDERR,"tried %s\n", disk_name);
	exit(1);
    }
    fstat(disk_fd, &sbuf);
    SECTORS = sbuf.st_size / DISK_BLOCK_SIZE;

    start = (long) 0;						/* start at 0 */
    num_sect = SECTORS;
    return 0;

}

#if 1
unsigned long readdisk(unsigned char *buf, unsigned long loc, unsigned long size)
{
    unsigned int no_sect = size / DISK_BLOCK_SIZE;
    unsigned int offset = loc % DISK_BLOCK_SIZE;
    int err, rc;
    char *temp;

    if ((offset > 0) || (size % DISK_BLOCK_SIZE))
	no_sect++;

    if ((temp = (unsigned char *) MALLOC(no_sect * DISK_BLOCK_SIZE)) == NULL)
    {
	fprintf(STDERR, "Memory allocation failed in readdisk\n");
	exit(1);
    }
    rc = lseek(disk_fd, (loc / DISK_BLOCK_SIZE) * DISK_BLOCK_SIZE, SEEK_SET);
    if (rc < 0)
    {
	perror("readdisk: seek failed");
	exit(1);
    }
    rc = read(disk_fd, temp, no_sect * DISK_BLOCK_SIZE);

/* should do byteswapping here?!? */

    if (rc == no_sect * DISK_BLOCK_SIZE)
    {
	memcpy(buf, &temp[offset], size);			/* no ending NULL */
	FREE(temp);
	return size;
    } else
    {
#if 0
	fprintf(STDERR, "Error %xh in Read Disk - loc:%lu head:%u cyl:%u sect:%u  no_sect:%u\n", rc, loc, head, cyl, sect, no_sect);
#endif
	FREE(temp);
	return 0;
    }
}
#else
unsigned long readdisk(unsigned char *buf, unsigned long loc, unsigned long size)
{
    unsigned short head, cyl, sect, offset;
    unsigned short rc, x;
    unsigned short no_sect;
    static unsigned char *temp = NULL;

#ifdef DEBUG_READDISK
    printf("--------Executing 'readdisk'----size:%lu--loc:%lu\n", size, loc);
#endif

    convert(loc, &head, &cyl, &sect, &offset);

    /*With floppys there are problems when trying to read beyond the last sector
       of a cylinder. So we try to deal with that. I never had this problem with
       harddisks, most likely, because my harddisks work in lba-mode, translating
       heads/sector/cylinder on their own. If we get read errors (rd!=0), the
       following piece of code needs to be improved
     */
    no_sect = size / DISK_BLOCK_SIZE;
    if ((offset > 0) || (size % DISK_BLOCK_SIZE))
	no_sect++;
    if (no_sect < 2)
	if (disk_no < 128)
	    no_sect = 1;					/*with floppys: minimum read is 1 sector */
	else
	    no_sect = 2;					/*with harddisks:               2 sectors */

    if ((temp = (unsigned char *) MALLOC(no_sect * DISK_BLOCK_SIZE)) == NULL)
    {
	fprintf(STDERR, "Memory allocation failed in readdisk\n");
    }
#ifdef DEBUG_READDISK
    printf("--------Reading----disk_no:%u head:%u cyl:%u sect:%u no_sect:%u offset:%u\n",
	   disk_no, head, cyl, sect, no_sect, offset);
#endif

    for (x = 0; x < 3; x++)					/*for floppy disks we sometimes have to try more than once */
    {
	if ((rc = biosdisk(READ_CMD, (int) disk_no, (int) head, (int) cyl, (int) sect, (int) no_sect, (void *) temp)) == 0)
	    break;
    }
    if (rc == 0)
    {
	memcpy(buf, &temp[offset], size);			/* no ending NULL */
	FREE(temp);
	return size;
    } else
    {
	fprintf(STDERR, "Error %xh in Read Disk - loc:%lu head:%u cyl:%u sect:%u  no_sect:%u\n", rc, loc, head, cyl, sect, no_sect);
	FREE(temp);
	return 0;
    }
}
#endif

/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!! Miller  10.11.98 !!!!!!!!!!!!!!!!!!!!!!!!!!! */
#if 1
unsigned long writedisk(unsigned char *buf, unsigned long loc, unsigned long size)
{
    unsigned int no_sect = size / DISK_BLOCK_SIZE;
    unsigned int offset = loc % DISK_BLOCK_SIZE;
    int err, rc;
    char *temp;

    if ((offset > 0) || (size % DISK_BLOCK_SIZE))
	no_sect++;

    if ((temp = (unsigned char *) MALLOC(no_sect * DISK_BLOCK_SIZE)) == NULL)
    {
	fprintf(STDERR, "Memory allocation failed in writedisk\n");
	exit(1);
    }
    rc = lseek(disk_fd, (loc / DISK_BLOCK_SIZE) * DISK_BLOCK_SIZE, SEEK_SET);
    if (rc < 0)
    {
	perror("writedisk: seek failed");
	exit(1);
    }
    if (read(disk_fd, temp, no_sect * DISK_BLOCK_SIZE) != no_sect * DISK_BLOCK_SIZE)
    {
	fprintf(STDERR, "Read Error %xh in Write Disk\n", rc);
	exit(1);
    }
    memcpy(&temp[offset], buf, size);
    rc = lseek(disk_fd, (loc / DISK_BLOCK_SIZE) * DISK_BLOCK_SIZE, SEEK_SET);
    if (rc < 0)
    {
	perror("writedisk: seek failed");
	exit(1);
    }
    rc = write(disk_fd, temp, no_sect * DISK_BLOCK_SIZE);

/* should do byteswapping here?!? */

    if (rc != no_sect * DISK_BLOCK_SIZE)
    {
#if 0
	fprintf(STDERR, "Error %xh in Write Disk - loc:%lu head:%u cyl:%u sect:%u  no_sect:%u\n", rc, loc, head, cyl, sect, no_sect);
#endif
	perror("writedisk: write failed:");
	FREE(temp);
	return 0;
    }
    FREE(temp);
    return size;
}
#else
unsigned long writedisk(unsigned char *buf, unsigned long loc, unsigned long size)
{
    unsigned short head, cyl, sect, offset;
    unsigned short rc, x;
    unsigned short no_sect;
    static unsigned char *temp = NULL;

#ifdef DEBUG_READDISK
    printf("--------Executing 'writedisk'----size:%lu--loc:%lu\n", size, loc);
#endif

    convert(loc, &head, &cyl, &sect, &offset);

    no_sect = size / DISK_BLOCK_SIZE;
    if ((offset > 0) || (size % DISK_BLOCK_SIZE))
	no_sect++;
    if (no_sect < 2)
	if (disk_no < 128)
	    no_sect = 1;					/*with floppys: minimum read is 1 sector */
	else
	    no_sect = 2;					/*with harddisks:               2 sectors */

    if ((temp = (unsigned char *) MALLOC(no_sect * DISK_BLOCK_SIZE)) == NULL)
    {
	fprintf(STDERR, "Memory allocation failed in writedisk\n");
	return -1;
    }
    /*we first have to read from disk and fill our temporary buffer */
    for (x = 0; x < 3; x++)					/*for floppy disks we sometimes have to try more than once */
    {
	if ((rc = biosdisk(READ_CMD, disk_no, head, cyl, sect, no_sect, temp)) == 0)
	    break;
    }
    if (rc)
	fprintf(STDERR, "Read Error %xh in Write Disk\n", rc);

    /*now we copy our own stuff into the temporary buffer */
    memcpy(&temp[offset], buf, size);				/* no ending NULL */


    /*now we can write to disk */
    for (x = 0; x < 3; x++)					/*for floppy disks we sometimes have to try more than once */
    {
	if ((rc = biosdisk(WRITE_CMD, disk_no, head, cyl, sect, no_sect, temp)) == 0)
	    break;
    }
    if (rc == 0)
    {
	rc = size;
    } else if (rc == 3)
    {
	fprintf(STDERR, "Write Error %xh in Write Disk - Disk is write protected !\nLwrite does not work in a DOS box under Windows 9x\n", rc);
	exit(-1);
    } else
    {
	fprintf(STDERR, "Write Error %xh in Write Disk - loc:%lu head:%u cyl:%u sect:%u  no_sect:%u\n", rc, loc, head, cyl, sect, no_sect);
	rc = 0;
    }

    FREE(temp);

    return rc;

}
#endif
/* !!!!!!!!!!!!!!!!!!!!!!!!!!! Ende Miller 10.11.98 !!!!!!!!!!!!!!!!!!!!!!!!! */
