/* ldir.h
 * Werner Zimmermann, FHTE Esslingen, Germany
 *
 * This file contains user settings and global defines, see also file
 README.TXT
 */

/*------------------------------------------------------------------------*/
/*User Options and Settings */

#ifndef UNIX
#define LINUX_DISK    "/dev/hda"				/* Name of your Linux partition
								   Specify partition number, eg. /dev/hda6
								   if you do not want ldir/lread to use
								   the first LINUX partition on your drive.
								   May also be a floppy like /dev/fd0.
								   Can be overwritten by -s/dev/...
								   command line switch */
#else
#define LINUX_DISK    "xx"
#endif
#ifndef UNIX
#define TIMEZONEDIFF    7200					/* (Your local time - GMT) *3600 */
#else
#define TIMEZONEDIFF    0
#endif

/*-------------------------------------------------------------------------*/
/*Debugging switches, normally no need to change */

/*
   #define DEBUG_DIR
   #define DEBUG_GROUP
   #define DEBUG_INODE
   #define DEBUG_MAIN  
   #define DEBUG_READDISK
   #define DEBUG_SUPER

   #define DEBUG_ALLOC
*/

/*------------------------------------------------------------------------*/
/*Global Defines, but nothing to edit for users */
#define READ_CMD  2						/*Disk Read  Command, do *NOT* change!!! */
#define PARA_CMD  8						/*Disk Write Command, do *NOT* change!!! */
#define WRITE_CMD 3						/*Disk Write Command, do *NOT* change!!! */

#define NONE      0						/*used in readdisk.c during linux partition search */
#define LINUX     1
#define EXTENDED  2
#define END_TABLE 3

#define INIT         0
#define KEEP_BUF     1						/*used to control free(buf) in read_inode() */
#define RELEASE_BUF  2
#define KILL_BUF     3

#define NORM 0
#define SELF 1

#define DISK_BLOCK_SIZE  512UL					/*size of harddisk sectors in byte */
#define NBLOCK           48UL					/*number of blocks for write buffer */
#define MBLOCK           48UL					/*number of blocks for read  buffer */

#define EXT2PART   0x83						/*signature of Extended2 Linux partitions */

#ifndef UNIX
#define TIMEZONE    TIMEZONEDIFF+14400
#else
#define TIMEZONE    0
#endif
