#include <stdlib.h>	/* atexit */
#include <go32.h>	/* dosmemget/put */
#include <dpmi.h>
#include <bios.h>       /* bios_k* */
#include "km.h"
#define MAX_IO_NBR 10
extern unsigned int HEADS;
extern unsigned int SECTORS;
extern unsigned int CYLINDERS;
static int dos_segment = 0;
static int dos_selector = 0;

void free_dos_buffer(void)
{
  __dpmi_free_dos_memory(dos_selector);
  dos_segment = dos_selector = 0;
}

int alloc_dos_buffer(void)
{
  if (dos_segment)
    return 0;
  if ((dos_segment = __dpmi_allocate_dos_memory(18*512/16, &dos_selector))== -1)
  {
    dos_segment = 0;
    return 1;
  }
  atexit(free_dos_buffer);
  return 0;
}

int hd_parm(byte drive, void*buffer)
{
  __dpmi_regs r;
  uchar buf[HDPARM_BUF_SIZ];
  if(dos_segment==0)
    if(alloc_dos_buffer())
      return 1;
  *(word*)&buf[0]=HDPARM_BUF_SIZ;
  r.h.ah = 0x48;
  r.x.ds = dos_segment;
  r.x.si = 0;
  r.h.dl = drive;
  dosmemput(buffer, HDPARM_BUF_SIZ, dos_segment<<4);
  __dpmi_int(0x13, &r);
  dosmemget(dos_segment<<4, HDPARM_BUF_SIZ, buffer);
  return 0;
}

int hd_super(int cmd, int drive, int head, int track,
	 int sector, int nsects, void *buffer)
{ // Limite CHS= 1023,255,63 = 8,064Mo ~= 7.8 Go
  if(track>=1024)
  {
    __dpmi_regs r;
    uchar buf[HD_RW_BUF_SIZ];
    int dos_segment2, dos_selector2, xfer2=nsects*512;
    if(dos_segment==0)
      if(alloc_dos_buffer())
	return 1;
    if ( (dos_segment2=__dpmi_allocate_dos_memory((xfer2 + 15) >> 4, &dos_selector2)) == -1 )
      return 1;
    *(word*)&buf[0]=HD_RW_BUF_SIZ;
    *(word*)&buf[2]=nsects;
    *(dword*)&buf[0x4]=dos_segment2<<16;
    *(dword*)&buf[0x8]=(track*(HEADS+1)+head)*
      SECTORS+sector-1;
    *(dword*)&buf[0xC]=0;

    r.x.ds = dos_segment;
    r.x.si = 0;
    r.h.dl = drive;
    switch(cmd)
    {
      case 2:
	r.h.ah = 0x42;
	break;
      case 3:
	r.x.ax = 0x4300;
	dosmemput(buffer,xfer2,dos_segment2<<4);
	break;
    }
    dosmemput(&buf, HD_RW_BUF_SIZ, dos_segment<<4);
    __dpmi_int(0x13, &r);
    if(cmd==2)
      dosmemget(dos_segment2<<4, xfer2, buffer);
    __dpmi_free_dos_memory(dos_selector2);
    return r.h.ah;
  }
  else
    return biosdisk(cmd, drive, head, track, sector, nsects, buffer);
}

int hd_identify(t_param_disk param_disk)
{
  uchar buf[0x200];
  if(biosdisk(PARA_CMD,param_disk->disk,0,0,1,1,buf))
    return 1;
  param_disk->cylinder=((buf[0] & 0x0C0)<<2)|buf[1];
  param_disk->head=buf[3];
  param_disk->sector=buf[0] & 0x3F;
  if(param_disk->cylinder==1023-1)
  {
    buf[0]=0x1A;
    buf[1]=0;
    hd_parm(param_disk->disk,&buf);
    param_disk->cylinder=*(word*)&buf[0x04];
    if(param_disk->cylinder)
    {
      param_disk->head=*(word*)&buf[0x08];
      param_disk->sector=*(word*)&buf[0x0C];
    }
    else
    {	/* ATTENTION qword en fait */
      param_disk->cylinder=(*(dword*)&buf[0x10]/255)/63-1;
      param_disk->head=255-1;
      param_disk->sector=63;
    }
  }
  return 0;
}

/*
int hd_read(byte nbr_secteur, void *nom_buffer, t_disk_cst lieu)
{
  int i,rc;
  for(i=0;i<MAX_IO_NBR;i++)
    if((rc=hd_super(2, lieu->disk, lieu->head,
	 lieu->cylinder, lieu->sector, nbr_secteur, nom_buffer))==0)
      return 0;
  return rc;
}

int hd_write(byte nbr_secteur, void *nom_buffer, t_disk_cst lieu)
{
  int i,rc;
  for(i=0;i<MAX_IO_NBR;i++)
    if((rc=hd_super(3, lieu->disk, lieu->head,
	 lieu->cylinder, lieu->sector, nbr_secteur, nom_buffer))==0)
      return 0;
  return rc;
}
*/
