/*      File codepic.c: 1.0 2/15/95 */
/*                                  */
/*      Version 0.002  John Favata  */

/* Revision history */
/* 2/16/95  generates less inline code */
/* 2/15/95  minor glitch in gsub */
/*                               */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "CPIC.h"

#define INCDIR "./"

#define ERRMSG "FATAL ERROR in code generation\n"
#define WARNING ";FYI: WARNING: Signed chars are not implemented\n"
#define CHAR_WARNING ";FYI: WARNING: only char ptrs are allowed\n"

/*      Define ASNM and LDNM to the names of the assembler and linker
	respectively */

/*
 *      Some predefinitions:
 *
 *      INTSIZE is the size of an integer in the target machine
 *      BYTEOFF is the offset of an byte within an integer on the
 *              target machine. (ie: 8080,pdp11 = 0, 6809 = 1,
 *              360 = 3)
 *      This compiler assumes that an integer is the SAME length as
 *      a pointer - in fact, the compiler uses INTSIZE for both.
 */
#define INTSIZE 1
#define BYTEOFF 0
#define DEFAULT_VARIABLES_OFFSET 12

FILE *Trace;
int TRACE;

int M_lib=FALSE;   /* see if we have to load MULT library */
int S_lib=FALSE;   /* see if we need shift library */
int G_lib=FALSE;   /* see if we need comp library */
int TargetCore=0;

/* Global Variable Section, originally from data.c */
char symtab[SYMTBSZ];
char *glbptr, *rglbptr, *locptr;
int	ws[WSTABSZ];
int	*wsptr;
int	swstcase[SWSTSZ];
int	swstlab[SWSTSZ];
int	swstp;
char litq[LITABSZ];
int	litptr;
char macq[MACQSIZE];
int	macptr;
char line[LINESIZE];
char mline[LINESIZE];
int	lptr, mptr;

/* miscellaneous storage */
int	nxtlab,
	litlab,
	stkp,
	argstk,
	ncmp,
	errcnt,
	glbflag,
	ctext,
	cmode,
	lastst;

FILE *input, *input2, *output;
FILE *inclstk[INCLSIZ];
int	inclsp;
char fname[20];

char quote[2];
char *cptr;
int	*iptr;
int	fexitlab;
int	iflevel, skiplevel;
int	errfile;
int	sflag;
int	bflag;
int	errs;
int	aflag;

/* End Global Variable Section */



/*
 *      print all assembler info before any code is generated
 *
 */
void inittrace(void)
{
    Trace=fopen("trace.out","w"); 
}

void endtrace(void)
{
    fclose(Trace);  
}

void header (void)
{

	if (TRACE) fprintf(output,";header()\n");

	outstr (";\tSmall C\n;\tVersion 2.0 (13/12/2000)\n");
	//FEvers();
	nl ();
	nl ();
	//outstr ("\tinclude '16c84.h'");
	nl ();
}

void nl (void)
{
	outbyte (EOL);
}


void initmac(void)
{
	if (TRACE)
	   fprintf(output,";initmac()\n");
	defmac("cpm\t1");
	defmac("I8080\t1");
	defmac("RMAC\t1");
	defmac("smallc\t1");
}


/* Error code from original error.c */

void error (char ptr[])
{
	FILE *tempfile;

	tempfile = output;
	output = stdout;
	doerror(ptr);
	output = tempfile;
	doerror(ptr);
	errcnt++;
}

void doerror(char *ptr) 
{
	int k;
	comment ();
	outstr (line);
	nl ();
	comment ();
	k = 0;
	while (k < lptr) {
		if (line[k] == 9)
			tab ();
		else
			outbyte (' ');
		k++;
	}
	outbyte ('^');
	nl ();
	comment ();
	outstr ("******  ");
	outstr (ptr);
	outstr ("  ******");
	nl ();
}

/* While code from original while.c */

void addwhile (int ptr[])
{
	int	k;

	if (wsptr == WSMAX) {
		error ("too many active whiles");
		return;
	}
	k = 0;
	while (k < WSSIZ)
		*wsptr++ = ptr[k++];
}

void delwhile (void)
{
	if (readwhile ())
		wsptr = wsptr - WSSIZ;
}

int readwhile (void)
{
	if (wsptr == ws) {
		error ("no active do/for/while/switch");
		return (0);
	} else
		return ((int)(wsptr-WSSIZ));
}

int findwhile (void)
{
	int	*ptr;

	for (ptr = wsptr; ptr != ws;) {
		ptr = ptr - WSSIZ;
		if (ptr[WSTYP] != WSSWITCH)
			return ((int)ptr);
	}
	error ("no active do/for/while");
	return (0);
}

int readswitch (void)
{
	int	*ptr;

	if ( (ptr = (int *) readwhile ()) )
		if (ptr[WSTYP] == WSSWITCH)
			return ((int)ptr);
	return (0);
}

void addcase (int val)
{
	int	lab;

	if (swstp == SWSTSZ)
		error ("too many case labels");
	else {
		swstcase[swstp] = val;
		swstlab[swstp++] = lab = getlabel ();
		printlabel (lab);
		col ();
		nl ();
	}
}



/* gen code from original gen.c */

/*
 *	return next available internal label number
 *
 */
int getlabel (void)
{
	return (nxtlab++);
}

/*
 *	print specified number as label
 */
void printlabel (int label)
{
	olprfix ();
	outdec (label);
}

/*
 *	glabel - generate label
 */
void glabel (char *lab)
{
	prefix ();
	outstr (lab);
	col ();
	nl ();
}

/*
 *	gnlabel - generate numeric label
 */
void gnlabel (int nlab)
{
	printlabel (nlab);
	col ();
	nl ();
}

int outbyte (char c)
{
	if (c == 0)
		return (0);
	fputc (c, output);
	return (c);
}

void outstr (char ptr[])
{
	int	k;

	k = 0;
	while (outbyte (ptr[k++]));
}


void tab (void)
{
	outbyte (9);
}

void ol (char ptr[])
{
	ot (ptr);
	nl ();
}

void ot (char ptr[])
{
	tab ();
	outstr (ptr);
}

void outdec (int number)
{
	int	k, zs;
	char	c;

	if (number == -32768) {
		outstr ("-32768");
		return;
	}
	zs = 0;
	k = 10000;
	if (number < 0) {
		number = (-number);
		outbyte ('-');
	}
	while (k >= 1) {
		c = number / k + '0';
		if ( (c != '0') | (k == 1) | (zs) ) 
		{
			zs = 1;
			outbyte (c);
		}
		number = number % k;
		k = k / 10;
	}
}

void outhexaddr(int number)
{
	if(number<16)
		fprintf(output,"0x0%x",number);
	else
		fprintf(output,"0x%x",number);
}
		
void store (int *lval)
{
	if (lval[1] == 0)
		putmem (lval[0]);
	else
		putstk (lval[1]);
}

void rvalue (int *lval)
{
	if ((lval[0] != 0) & (lval[1] == 0))
		getmem (lval[0]);
	else
		indirect (lval[1]);
}

void test (int label, int ft)
{
	needbrack ("(");
	expression (YES);
	needbrack (")");
	testjump (label, ft);
}


/* io code from original io.c */

/*
 *	open input file
 */
int openin (char *p)
{
	strcpy(fname, p);
	fixname (fname);
	if (!checkname (fname))
		return (NO);
	if ((input = fopen (fname, "r")) == NULL) {
		pl ("Open failure\n");
		return (NO);
	}
	kill ();
	return (YES);
}

/*
 *	open output file
 */
int openout (void)
{
	char filenametosaveto[20];
	int DotPosition=0;
	int Found=0;
	
	while(Found==0)
	{
		if(fname[DotPosition]=='.')
		{
			Found=1;
		}
		else
		{
			DotPosition++;
		}
	}

	
	strncpy(filenametosaveto,fname,DotPosition);
	filenametosaveto[DotPosition]='\0';
	strcat(filenametosaveto,".asm");

	outfname (fname);
	if ((output = fopen (filenametosaveto, "w")) == NULL) {
		pl ("Open failure");
		return (NO);
	}
	kill ();
	return (YES);
}

/*
 *	change input filename to output filename
 */
void outfname (char *s)
{
	while(*s!='.') s++;

	s++;
	*s='a';
	*(s+1)='s';
	*(s+2)='m';

	//strcpy(*s,"asm");
	//*s = "asm";
}

/*
 *	remove NL from filenames
 *
 */
void fixname (char *s)
{
	while (*s && *s++ != EOL);
	if (!*s) return;
	*(--s) = 0;
}

/*
 *	check that filename is "*.c"
 */
int checkname (char *s)
{
	while (*s)
		s++;
	if (*--s != 'c')
		return (NO);
	if (*--s != '.')
		return (NO);
	return (YES);
}

void kill (void)
{
	lptr = 0;
	line[lptr] = 0;
}

void finline (void)
{
	int	k;
	FILE	*unit;

	FOREVER {
		if (feof (input))
			return;
		if ((unit = input2) == NULL)
			unit = input;
		kill ();
		while ((k = fgetc (unit)) != EOF) {
			if ((k == EOL) | (lptr >= LINEMAX))
				break;
			line[lptr++] = k;
		}
		line[lptr] = 0;
		if (k <= 0)
			if (input2 != NULL) {
				input2 = inclstk[--inclsp];
				fclose (unit);
			}
		if (lptr) {
			if ((ctext) & (cmode)) {
				comment ();
				outstr (line);
				nl ();
			}
			lptr = 0;
			return;
		}
	}
}

int inbyte (void)
{
	while (ch () == 0) {
		if (feof (input))
			return (0);
		preprocess ();
	}
	return (gch ());
}

int inchar (void)
{
	if (ch () == 0)
		finline ();
	if (feof (input))
		return (0);
	return (gch ());
}

int gch (void)
{
	if (ch () == 0)
		return (0);
	else
		return (line[lptr++] & 127);
}

int nch (void)
{
	if (ch () == 0)
		return (0);
	else
		return (line[lptr + 1] & 127);
}

int ch (void)
{
	return (line[lptr] & 127);
}

/*
 *	print a carriage return and a string only to console
 *
 */
void pl (char *str)
{
	int	k;

	k = 0;
	putchar (EOL);
	while (str[k])
		putchar (str[k++]);
}


/* function code, originally from function.c */


/*
 *	begin a function
 *
 *	called from "parse", this routine tries to make a function out
 *	of what follows
 *	modified version.  p.l. woods
 *
 */

int argtop;

void newfunc (void)
{
	char	n[NAMESIZE], *ptr;
	fexitlab = getlabel();

	if (!symname (n) ) {
		error ("illegal function or declaration");
		kill ();
		return;
	}
	if ( (ptr = (char *) findglb (n)) ) {
		if (ptr[IDENT] != FUNCTION)
			multidef (n);
		else if (ptr[OFFSET] == FUNCTION)
			multidef (n);
		else
			ptr[OFFSET] = FUNCTION;
	} else
		addglb (n, FUNCTION, CINT, FUNCTION, PUBLIC);
	prologue ();
	if (!match ("("))
		error ("missing open paren");
	prefix ();
	outstr (n);
	col ();
	nl ();
	locptr = STARTLOC;
	argstk = 0;
	while (!match (")")) {
		if (symname (n)) {
			if (findloc (n))
				multidef (n);
			else {
				addloc (n, 0, 0, argstk, AUTO);
				argstk = argstk + intsize();
			}
		} else {
			error ("illegal argument name");
			junk ();
		}
		blanks ();
		if (!streq (line + lptr, ")")) {
			if (!match (","))
				error ("expected comma");
		}
		if (endst ())
			break;
	}
	stkp = 0;
	argtop = argstk;
	while (argstk) {
		if (amatch ("register", 8)) {
			if (amatch("char", 4))
				getarg(CCHAR);
			else if (amatch ("int", 3))
				getarg(CINT);
			else
				getarg(CINT);
			ns();
		} else if (amatch ("char", 4)) {
			getarg (CCHAR);
			ns ();
		} else if (amatch ("int", 3)) {
			getarg (CINT);
			ns ();
		} else {
			error ("wrong number args");
			break;
		}
	}
	statement(YES);
	printlabel(fexitlab);
	col();
	nl();
	modstk (0);
	gret ();
	stkp = 0;
	locptr = STARTLOC;
}

/*
 *	declare argument types
 *
 *	called from "newfunc", this routine add an entry in the local
 *	symbol table for each named argument
 *	completely rewritten version.  p.l. woods
 *
 */
void getarg (int t)
{
	int	j, legalname, address;
	char	n[NAMESIZE], *argptr;

	FOREVER {
		if (argstk == 0)
			return;
		if (match ("*"))
			j = POINTER;
		else
			j = VARIABLE;
		if (!(legalname = symname (n)))
			illname ();
		if (match ("[")) {
			while (inbyte () != ']')
				if (endst ())
					break;
			j = POINTER;
		}
		if (legalname) {
			if ( (argptr = (char *) findloc (n)) ) {
				argptr[IDENT] = j;
				argptr[TYPE] = t;
				address = argtop - glint(argptr) - 1; /* -1 is needed to balance stack */
				if (t == CCHAR && j == VARIABLE)
					address = address + byteoff();
				argptr[OFFSET] = (address) & 0xff;
				argptr[OFFSET + 1] = (address >> 8) & 0xff;
			} else
				error ("expecting argument name");
		}
		argstk = argstk - intsize();
		if (endst ())
			return;
		if (!match (","))
			error ("expected comma");
	}
}

/* lex code, originally from lex.c */

/*
 *	semicolon enforcer
 *
 *	called whenever syntax requires a semicolon
 *
 */
void ns (void)
{
	if (!match (";"))
		error ("missing semicolon");
}

void junk (void)
{
	if (an (inbyte ()))
		while (an (ch ()))
			gch ();
	else
		while (an (ch ())) {
			if (ch () == 0)
				break;
			gch ();
		}
	blanks ();
}

int endst (void)
{
	blanks ();
	return ((streq (line + lptr, ";") | (ch () == 0)));
}

void needbrack (char *str)
{
	if (!match (str)) {
		error ("missing bracket");
		comment ();
		outstr (str);
		nl ();
	}
}

/*
 *	test if given character is alpha
 *
 */
int alpha (char c)
{
	c = c & 127;
	return (((c >= 'a') & (c <= 'z')) |
		((c >= 'A') & (c <= 'Z')) |
		(c == '_'));
}

/*
 *	test if given character is numeric
 *
 */
int numeric (char c)
{
	c = c & 127;
	return ((c >= '0') & (c <= '9'));
}

/*
 *	test if given character is alphanumeric
 *
 */
int an (char c)
{
	return ((alpha (c)) | (numeric (c)));
}

int sstreq (char *str1) 
{
	return (streq(line + lptr, str1));
}

int streq (char str1[], char str2[])
{
	int	k;

	k = 0;
	while (str2[k]) {
		if ((str1[k] != str2[k]))
			return (0);
		k++;
	}
	return (k);
}

int astreq (char str1[], char str2[], int len)
{
	int	k;

	k = 0;
	while (k < len) {
		if ((str1[k] != str2[k]))
			break;
		if (str1[k] == 0)
			break;
		if (str2[k] == 0)
			break;
		k++;
	}
	if (an (str1[k]))
		return (0);
	if (an (str2[k]))
		return (0);
	return (k);
}

int match (char *lit)
{
	int	k;

	blanks ();
	if ( (k = (int) streq (line + lptr, lit)) ) {
		lptr = lptr + k;
		return (1);
	}
	return (0);
}

int amatch (char *lit, int len)
{
	int	k;

	blanks ();
	if ( (k = (int)astreq (line + lptr, lit, len)) ) {
		lptr = lptr + k;
		while (an (ch ()))
			inbyte ();
		return (1);
	}
	return (0);
}

void blanks (void)
{
	FOREVER {
		while (ch () == 0) {
			preprocess ();
			if (feof (input))
				break;
		}
		if (ch () == ' ')
			gch ();
		else if (ch () == 9)
			gch ();
		else
			return;
	}
}


/* sym code, originilly from sym.c */

/*
 *	declare a static variable
 */
void declglb (int typ, int stor)
{
	int	k, j;
	char	sname[NAMESIZE];

	FOREVER {
		FOREVER {
			if (endst ())
				return;
			k = 1;
			if (match ("*"))
				j = POINTER;
			else
				j = VARIABLE;
			if (!symname (sname))
				illname ();
			if (findglb (sname))
				multidef (sname);
			if (match ("[")) {
				k = needsub ();
				if (k || stor == EXTERN)
					j = ARRAY;
				else
					j = POINTER;
			}
			addglb (sname, j, typ, k, stor);
			break;
		}
		if (!match (","))
			return;
	}
}

/*
 *	declare local variables
 *
 *	works just like "declglb", but modifies machine stack and adds
 *	symbol table entry with appropriate stack offset to find it again
 */
void declloc (int typ, int stclass)
{
	int	k, j;
	char	sname[NAMESIZE];

	FOREVER {
		FOREVER {
			if (endst ())
				return;
			if (match ("*"))
				j = POINTER;
			else
				j = VARIABLE;
			if (!symname (sname))
				illname ();
			if (findloc (sname))
				multidef (sname);
			if (match ("[")) {
				k = needsub ();
				if (k) {
					j = ARRAY;
					if (typ == CINT)
						k = k * intsize();
				} else {
					j = POINTER;
					k = intsize();
				}
			} else
				if ((typ == CCHAR) & (j != POINTER))
					k = 1;
				else
					k = intsize();
			if (stclass != LSTATIC) {
				k = galign(k);
				stkp = modstk (stkp - k);
				addloc (sname, j, typ, stkp, AUTO);
			} else
				addloc( sname, j, typ, k, LSTATIC);
			break;
		}
		if (!match (","))
			return;
	}
}

/*
 *	get required array size
 */
int needsub (void )
{
	int	num[1];

	if (match ("]"))
		return (0);
	if (!number (num)) {
		error ("must be constant");
		num[0] = 1;
	}
	if (num[0] < 0) {
		error ("negative size illegal");
		num[0] = (-num[0]);
	}
	needbrack ("]");
	return (num[0]);
}

int findglb (char *sname)
{
	char	*ptr;

	ptr = STARTGLB;
	while (ptr != glbptr) {
		if (astreq (sname, ptr, NAMEMAX))
			return ((int)ptr);
		ptr = ptr + SYMSIZ;
	}
	return (0);
}

int findloc (char *sname)
{
	char	*ptr;

	ptr = locptr;
	while (ptr != STARTLOC) {
		ptr = ptr - SYMSIZ;
		if (astreq (sname, ptr, NAMEMAX))
			return ((int)ptr);
	}
	return (0);
}

int addglb (char *sname, char id, char typ, int value, int stor)
{
	char	*ptr;

	if ( (cptr = (char *)findglb (sname)) )
		return ((int) cptr);
	if (glbptr >= ENDGLB) {
		error ("global symbol table overflow");
		return (0);
	}
	cptr = ptr = glbptr;
	while (an (*ptr++ = *sname++));
	cptr[IDENT] = id;
	cptr[TYPE] = typ;
	cptr[STORAGE] = stor;
	cptr[OFFSET] = value & 0xff;
	cptr[OFFSET+1] = (value >> 8) & 0xff;
	glbptr = glbptr + SYMSIZ;
	return ((int)cptr);
}

int addloc (char *sname, char id, char typ, int value, int stclass)
{
	char	*ptr;
	int	k;

	if ((cptr = (char *)findloc (sname)))
		return ((int)cptr);
	if (locptr >= ENDLOC) {
		error ("local symbol table overflow");
		return (0);
	}
	cptr = ptr = locptr;
	while (an (*ptr++ = *sname++));
	cptr[IDENT] = id;
	cptr[TYPE] = typ;
	cptr[STORAGE] = stclass;
	if (stclass == LSTATIC) {
		gdata();
		printlabel(k = getlabel());
		col();
		defstorage();
		onum(value);
		nl();
		gtext();
		value = k;
	} else
		value = galign(value);
	cptr[OFFSET] = value & 0xff;
	cptr[OFFSET+1] = (value >> 8) & 0xff;
	locptr = locptr + SYMSIZ;
	return ((int)cptr);
}

/*
 *	test if next input string is legal symbol name
 *
 */
int symname (char *sname)
{
	int	k;

	blanks ();
	if (!alpha (ch ()))
		return (0);
	k = 0;
	while (an (ch ()))
		sname[k++] = gch ();
	sname[k] = 0;
	return (1);
}

void illname (void )
{
	error ("illegal symbol name");
}

void multidef (char *sname)
{
	error ("already defined");
	comment ();
	outstr (sname);
	nl ();
}

int glint(char *syment)
{
	int l,u,r;
	l = syment[OFFSET];
	u = syment[OFFSET+1];
	r = (l & 0xff) + ((u << 8) & ~0x00ff);
	return (r);
}


/* primary code, originally from primary.c */

int primary (int *lval)
{
	char	*ptr, sname[NAMESIZE];
	int	num[1];
	int	k;

	lval[2] = 0;  /* clear pointer/array type */
	if (match ("(")) {
		k = heir1 (lval);
		needbrack (")");
		return (k);
	}
	if (amatch("sizeof", 6)) {
		needbrack("(");
		immed();
		if (amatch("int", 3)) onum(intsize());
		else if (amatch("char", 4)) onum(1);
		else if (symname(sname)) {
			if ((ptr = (char *)findloc(sname)) ||
				(ptr = (char *)findglb(sname))) {
				if (ptr[STORAGE] == LSTATIC)
					error("sizeof local static");
				k = glint(ptr);
				if ((ptr[TYPE] == CINT) ||
					(ptr[IDENT] == POINTER))
					k *= intsize();
				onum(k);
			} else {
				error("sizeof undeclared variable");
				onum(0);
			}
		} else {
			error("sizeof only on type or variable");
		}
		outbyte('\''); /* Added 14/01/01 */
		needbrack(")");
		nl();
		ol ("movwf _primary"); /* added */
		return(lval[0] = lval[1] = 0);
	}
	if (symname (sname)) {
		if ((ptr = (char *)findloc (sname))) {
			getloc (ptr);
			lval[0] = (int) ptr;
			lval[1] =  ptr[TYPE];
			if (ptr[IDENT] == POINTER) {
				lval[1] = CINT;
				lval[2] = ptr[TYPE];
			}
			if (ptr[IDENT] == ARRAY) {
				lval[2] = ptr[TYPE];
				lval[2] = 0;
				return (0);
			}
			else
				return (1);
		}
		if (ptr = (char *)findglb (sname))
			if (ptr[IDENT] != FUNCTION) {
				lval[0] = (int)ptr;
				lval[1] = 0;
				if (ptr[IDENT] != ARRAY) {
					if (ptr[IDENT] == POINTER)
						lval[2] = ptr[TYPE];
					return (1);
				}
				immed ();
				prefix ();
				outstr (ptr);
				outbyte('\''); /* Added 14/01/01 */
                col();   /* keep labels correct */
				nl ();
				lval[1] = lval[2] = ptr[TYPE];
				lval[2] = 0;
				ol ("movwf _primary"); /* added */
				return (0);
			}
		blanks ();
		if (ch() != '(')
			error("undeclared variable");
		ptr = (char *)addglb (sname, FUNCTION, CINT, 0, PUBLIC);
		lval[0] = (int)ptr;
		lval[1] = 0;
		return (0);
	}
	if (constant (num))
		return (lval[0] = lval[1] = 0);
	else {
		error ("invalid expression");
		immed ();
		onum (0);
		outbyte('\''); /* Added 14/01/01 */
		nl ();
		junk ();
		return (0);
	}
}

/*
 *	true if val1 -> int pointer or int array and val2 not pointer or array
 */
int dbltest (int val1[], int val2[])
{
	if (val1 == NULL)
		return (FALSE);
	if (val1[2] != CINT)
		return (FALSE);
	if (val2[2])
		return (FALSE);
	return (TRUE);
}

/*
 *	determine type of binary operation
 */
void result (int lval[], int lval2[])
{
	if (lval[2] && lval2[2])
		lval[2] = 0;
	else if (lval2[2]) {
		lval[0] = lval2[0];
		lval[1] = lval2[1];
		lval[2] = lval2[2];
	}
}
		
int constant (int val[])
{
	if (number (val))
	{
		immed ();
	}
	else if (pstr (val))
	{
		immed ();
	}
	else if (qstr (val)) 
	{
		immed ();
		
                /* fix string labels */
		/* output only offset
                printlabel (litlab);
                col();
		outbyte ('+');
                */
	} else
		return (0);
	onum (val[0]);
	outbyte('\''); /* Added 14/01/01 */
	nl ();
	return (1);
}

int number (int val[])
{
	int	k, minus, base;
	char	c;

	k = minus = 1;
	while (k) {
		k = 0;
		if (match ("+"))
			k = 1;
		if (match ("-")) {
			minus = (-minus);
			k = 1;
		}
	}
	if (!numeric (c = ch ()))
		return (0);
	if (match ("0x") || match ("0X"))
		while (numeric (c = ch ()) ||
		       (c >= 'a' && c <= 'f') ||
		       (c >= 'A' && c <= 'F')) {
			inbyte ();
			k = k * 16 +
			    (numeric (c) ? (c - '0') : ((c & 07) + 9));
		}
	else {
		base = (c == '0') ? 8 : 10;
		while (numeric (ch ())) {
			c = inbyte ();
			k = k * base + (c - '0');
		}
	}
	if (minus < 0)
		k = (-k);
	val[0] = k;
	return (1);
}

int pstr (int val[])
{
	int	k;
	char	c;

	k = 0;
	if (!match ("'"))
		return (0);
	while ((c = gch ()) != 39) {
		c = (c == '\\') ? spechar(): c;
		k = (k & 255) * 256 + (c & 255);
	}
	val[0] = k;
	return (1);
}

int qstr (int val[])
{
	char	c;

	if (!match (quote))
		return (0);
	val[0] = litptr;
	while (ch () != '"') {
		if (ch () == 0)
			break;
		if (litptr >= LITMAX) {
			error ("string space exhausted");
			while (!match (quote))
				if (gch () == 0)
					break;
			return (1);
		}
		c = gch();
		litq[litptr++] = (c == '\\') ? spechar(): c;
	}
	gch ();
	litq[litptr++] = 0;
	return (1);
}

/*
 *	decode special characters (preceeded by back slashes)
 */
int spechar(void ) 
{
	char c;
	c = ch();

	if	(c == 'n') c = EOL;
	else if	(c == 't') c = TAB;
	else if (c == 'r') c = CR;
	else if (c == 'f') c = FFEED;
	else if (c == 'b') c = BKSP;
	else if (c == '0') c = EOS;
	else if (c == EOS) return;

	gch();
	return (c);
}

/*
 *	perform a function call
 *
 *	called from "heir11", this routine will either call the named
 *	function, or if the supplied ptr is zero, will call the contents
 *	of HL
 *
 */
void callfunction (char *ptr)
{
	int	nargs;

	nargs = 0;
	blanks ();
	if (ptr == 0)
		gpush ();
	while (!streq (line + lptr, ")")) {
		if (endst ())
			break;
		expression (NO);
		if (ptr == 0)
			swapstk ();
		gpush ();
		nargs = nargs + intsize();
		if (!match (","))
			break;
	}
	needbrack (")");
	if (aflag)
		gnargs(nargs / intsize());
	if (ptr)
		gcall (ptr);
	else
		callstk ();
	stkp = modstk (stkp + nargs);
}

void needlval (void )
{
	error ("must be lvalue");
}


/* stmt code, originally from stmt.c */

/*
 *	statement parser
 *
 *	called whenever syntax requires a statement.  this routine
 *	performs that statement and returns a number telling which one
 *
 *	'func' is true if we require a "function_statement", which
 *	must be compound, and must contain "statement_list" (even if
 *	"declaration_list" is omitted)
 */

int statement (int func)
{
	if ((ch () == 0) & feof (input))
		return (0);
	lastst = 0;
	if (func)
		if (match ("{")) {
			compound (YES);
			return (lastst);
		} else
			error ("function requires compound statement");
	if (match ("{"))
		compound (NO);
	else
		stst ();
	return (lastst);
}

/*
 *	declaration
 */
int stdecl (void )
{
	if (amatch("register", 8))
		doldcls(DEFAUTO);
	else if (amatch("auto", 4))
		doldcls(DEFAUTO);
	else if (amatch("static", 6))
		doldcls(LSTATIC);
	else if (doldcls(AUTO)) ;
	else
		return (NO);
	return (YES);
}

int doldcls(int stclass)
{
	blanks();
	if (amatch("char", 4))
		declloc(CCHAR, stclass);
	else if (amatch("int", 3))
		declloc(CINT, stclass);
	else if (stclass == LSTATIC || stclass == DEFAUTO)
		declloc(CINT, stclass);
	else
		return(0);
	ns();
	return(1);
}


/*
 *	non-declaration statement
 */
void stst (void)
{
	if (amatch ("if", 2)) {
		doif ();
		lastst = STIF;
	} else if (amatch ("while", 5)) {
		dowhile ();
		lastst = STWHILE;
	} else if (amatch ("switch", 6)) {
		doswitch ();
		lastst = STSWITCH;
	} else if (amatch ("do", 2)) {
		dodo ();
		ns ();
		lastst = STDO;
	} else if (amatch ("for", 3)) {
		dofor ();
		lastst = STFOR;
	} else if (amatch ("return", 6)) {
		doreturn ();
		ns ();
		lastst = STRETURN;
	} else if (amatch ("break", 5)) {
		dobreak ();
		ns ();
		lastst = STBREAK;
	} else if (amatch ("continue", 8)) {
		docont ();
		ns ();
		lastst = STCONT;
	} else if (match (";"))
		;
	else if (amatch ("case", 4)) {
		docase ();
		lastst = statement (NO);
	} else if (amatch ("default", 7)) {
		dodefault ();
		lastst = statement (NO);
	} else if (match ("#asm")) {
		doasm ();
		lastst = STASM;
	} else if (match ("{"))
		compound (NO);
	else {
		expression (YES);
/*		if (match (":")) {
			dolabel ();
			lastst = statement (NO);
		} else {
*/			ns ();
			lastst = STEXP;
/*		}
*/	}
}

/*
 *	compound statement
 *
 *	allow any number of statements to fall between "{" and "}"
 *
 *	'func' is true if we are in a "function_statement", which
 *	must contain "statement_list"
 */
void compound (int func)
{
	int	decls;

	decls = YES;
	ncmp++;
	while (!match ("}")) {
		if (feof (input))
			return;
		if (decls) {
			if (!stdecl ())
				decls = NO;
		} else
			stst ();
	}
	ncmp--;
}

/*
 *	"if" statement
 */
void doif (void )
{
	int	fstkp, flab1, flab2;
	char	*flev;

	flev = locptr;
	fstkp = stkp;
	flab1 = getlabel ();
	test (flab1, FALSE);
	statement (NO);
	stkp = modstk (fstkp);
	locptr = flev;
	if (!amatch ("else", 4)) {
		gnlabel (flab1);
		return;
	}
	jump (flab2 = getlabel ());
	gnlabel (flab1);
	statement (NO);
	stkp = modstk (fstkp);
	locptr = flev;
	gnlabel (flab2);
}

/*
 *	"while" statement
 */
void dowhile (void )
{
	int	ws[7];

	ws[WSSYM] = (int)locptr;
	ws[WSSP] = stkp;
	ws[WSTYP] = WSWHILE;
	ws[WSTEST] = getlabel ();
	ws[WSEXIT] = getlabel ();
	addwhile (ws);
	gnlabel (ws[WSTEST]);
	test (ws[WSEXIT], FALSE);
	statement (NO);
	jump (ws[WSTEST]);
	gnlabel (ws[WSEXIT]);
	locptr = (char *)ws[WSSYM];
	stkp = modstk (ws[WSSP]);
	delwhile ();
}

/*
 *	"do" statement
 */
void dodo (void )
{
	int	ws[7];

	ws[WSSYM] = (int)locptr;
	ws[WSSP] = stkp;
	ws[WSTYP] = WSDO;
	ws[WSBODY] = getlabel ();
	ws[WSTEST] = getlabel ();
	ws[WSEXIT] = getlabel ();
	addwhile (ws);
	gnlabel (ws[WSBODY]);
	statement (NO);
	if (!match ("while")) {
		error ("missing while");
		return;
	}
	gnlabel (ws[WSTEST]);
	test (ws[WSBODY], TRUE);
	gnlabel (ws[WSEXIT]);
	locptr = (char *) ws[WSSYM];
	stkp = modstk (ws[WSSP]);
	delwhile ();
}

/*
 *	"for" statement
 */
void dofor (void )
{
	int	ws[7],
		*pws;

	ws[WSSYM] = (int) locptr;
	ws[WSSP] = stkp;
	ws[WSTYP] = WSFOR;
	ws[WSTEST] = getlabel ();
	ws[WSINCR] = getlabel ();
	ws[WSBODY] = getlabel ();
	ws[WSEXIT] = getlabel ();
	addwhile (ws);
	pws = (int *) readwhile ();
	needbrack ("(");
	if (!match (";")) {
		expression (YES);
		ns ();
	}
	gnlabel (pws[WSTEST]);
	if (!match (";")) {
		expression (YES);
		testjump (pws[WSBODY], TRUE);
		jump (pws[WSEXIT]);
		ns ();
	} else
		pws[WSTEST] = pws[WSBODY];
	gnlabel (pws[WSINCR]);
	if (!match (")")) {
		expression (YES);
		needbrack (")");
		jump (pws[WSTEST]);
	} else
		pws[WSINCR] = pws[WSTEST];
	gnlabel (pws[WSBODY]);
	statement (NO);
	jump (pws[WSINCR]);
	gnlabel (pws[WSEXIT]);
	locptr = (char *)pws[WSSYM];
	stkp = modstk (pws[WSSP]);
	delwhile ();
}

/*
 *	"switch" statement
 */
void doswitch (void )
{
	int	ws[7];
	int	*ptr;

	ws[WSSYM] = (int)locptr;
	ws[WSSP] = stkp;
	ws[WSTYP] = WSSWITCH;
	ws[WSCASEP] = swstp;
	ws[WSTAB] = getlabel ();
	ws[WSDEF] = ws[WSEXIT] = getlabel ();
	addwhile (ws);
#ifdef OLD_SWITCH
	immed ();
	printlabel (ws[WSTAB]);
    col();  /* added 2/12/95 */
	nl ();
	gpush ();
#endif
	needbrack ("(");
	expression (YES);
	needbrack (")");

      /* stkp = stkp + intsize(); */  /* '?case' will adjust the stack */

/* new code generation */

	gjcase ( ws[WSTAB] );

/* end of new code generation */

	statement (NO);
	ptr = (int *)readswitch ();
	jump (ptr[WSEXIT]);
	dumpsw (ptr);
	gnlabel (ptr[WSEXIT]);
	locptr = (char *)ptr[WSSYM];
	stkp = modstk (ptr[WSSP]);
	swstp = ptr[WSCASEP];
	delwhile ();
}

/*
 *	"case" label
 */
void docase (void )
{
	int	val;

	val = 0;
	if (readswitch ()) {
		if (!number (&val))
			if (!pstr (&val))
				error ("bad case label");
		addcase (val);
		if (!match (":"))
			error ("missing colon");
	} else
		error ("no active switch");
}

/*
 *	"default" label
 */
void dodefault (void )
{
	int	*ptr,
		lab;

	if ((ptr = (int *)readswitch ()) ) {
		ptr[WSDEF] = lab = getlabel ();
		gnlabel (lab);
		if (!match (":"))
			error ("missing colon");
	} else
		error ("no active switch");
}

/*
 *	"return" statement
 */
void doreturn (void )
{
	if (endst () == 0)
		expression (YES);
	jump(fexitlab);
}

/*
 *	"break" statement
 */
void dobreak (void )
{
	int	*ptr;

	if ((ptr = (int *)readwhile ()) == 0)
		return;
	modstk (ptr[WSSP]);
	jump (ptr[WSEXIT]);
}

/*
 *	"continue" statement
 */
void docont (void )
{
	int	*ptr;

	if ((ptr = (int *)findwhile ()) == 0)
		return;
	modstk (ptr[WSSP]);
	if (ptr[WSTYP] == WSFOR)
		jump (ptr[WSINCR]);
	else
		jump (ptr[WSTEST]);
}

/*
 *	dump switch table
 */

void dumpsw (int ws[])
{
	int	i,j;

 /*	gdata ();  */
	gnlabel (ws[WSTAB]);
	if (ws[WSCASEP] != swstp) {
		j = ws[WSCASEP];
		while (j < swstp) {
			i = 4;
			while (i--) {
                                outcase( CASE, swstcase[j], swstlab[j]);
                                j++;
				if ((i == 0) | (j >= swstp)) {
					break;
				}
			}
		}
	}
	outcase( DEFAULT, 0, ws[WSDEF] );
    /*	gtext ();  */
}

/* preproc code, originally from preproc.c */

/*
 *	open an include file
 */
void doinclude (void )
{
	FILE	*inp2;

	blanks ();
	if (inp2 = (FILE *)fixiname ())
		if (inclsp < INCLSIZ) {
			inclstk[inclsp++] = input2;
			input2 = inp2;
		} else {
			fclose (inp2);
			error ("too many nested includes");
		}
	else {
		error ("Could not open include file");
	}
	kill ();
}

/*
 *	fixiname - remove "brackets" around include file name
 */
int fixiname (void )
{
	char	c1, c2, *p, *ibp;
	char buf[20];
	FILE *fp;
	char buf2[100];

	ibp = &buf[0];

	if ((c1 = gch ()) != '"' && c1 != '<')
		return ((int)NULL);
	for (p = line + lptr; *p ;)
		*ibp++ = *p++;
	c2 = *(--p);
	if (c1 == '"' ? (c2 != '"') : (c2 != '>')) {
		error ("incorrect delimiter");
		return ((int)NULL);
	}
	*(--ibp) = 0;
	fp = NULL;
	if (c1 == '<' || !(fp = fopen(buf, "r"))) {
		strcpy(buf2, DEFLIB);
		strcat(buf2, buf);
		fp = fopen(buf2, "r");
	}
	return((int)fp);
}

/*
 *	"asm" pseudo-statement
 *
 *	enters mode where assembly language statements are passed
 *	intact through parser
 *
 */
void doasm (void )
{
	cmode = 0;
	FOREVER {
		finline ();
		if (match ("#endasm"))
			break;
		if (feof (input))
			break;
		outstr (line);
		nl ();
	}
	kill ();
	cmode = 1;
}

void dodefine (void )
{
	addmac();
}

void doundef (void )
{
	int	mp;
	char	sname[NAMESIZE];

	if (!symname(sname)) {
		illname();
		kill();
		return;
	}

	if ((mp = findmac(sname)) )
		delmac(mp);
	kill();
}

void preprocess (void )
{
	if (ifline()) return;
	while (cpp());
}

void doifdef (int ifdef)
{
	char sname[NAMESIZE];
	int k;

	blanks();
	++iflevel;
	if (skiplevel) return;
	k = symname(sname) && findmac(sname);
	if (k != ifdef) skiplevel = iflevel;
}

int ifline(void)
{
	FOREVER {
		finline();
		if (feof(input)) return(1);
		if (match("#ifdef")) {
			doifdef(YES);
			continue;
		} else if (match("#ifndef")) {
			doifdef(NO);
			continue;
		} else if (match("#else")) {
			if (iflevel) {
				if (skiplevel == iflevel) skiplevel = 0;
				else if (skiplevel == 0) skiplevel = iflevel;
			} else noiferr();
			continue;
		} else if (match("#endif")) {
			if (iflevel) {
				if (skiplevel == iflevel) skiplevel = 0;
				--iflevel;
			} else noiferr();
			continue;
		}
		if (!skiplevel) return(0);
	}
}

void noiferr(void )
{
	error("no matching #if...");
}


int cpp (void )
{
	int	k;
	char	c, sname[NAMESIZE];
	int	tog;
	int	cpped;		/* non-zero if something expanded */

	cpped = 0;
	/* don't expand lines with preprocessor commands in them */
	if (!cmode || line[0] == '#') return(0);

	mptr = lptr = 0;
	while (ch ()) {
		if ((ch () == ' ') | (ch () == 9)) {
			keepch (' ');
			while ((ch () == ' ') | (ch () == 9))
				gch ();
		} else if (ch () == '"') {
			keepch (ch ());
			gch ();
			while (ch () != '"') {
				if (ch () == 0) {
					error ("missing quote");
					break;
				}
				if (ch() == '\\') keepch(gch());
				keepch (gch ());
			}
			gch ();
			keepch ('"');
		} else if (ch () == 39) {
			keepch (39);
			gch ();
			while (ch () != 39) {
				if (ch () == 0) {
					error ("missing apostrophe");
					break;
				}
				if (ch() == '\\') keepch(gch());
				keepch (gch ());
			}
			gch ();
			keepch (39);
		} else if ((ch () == '/') & (nch () == '*')) {
			inchar ();
			inchar ();
			while ((((c = ch ()) == '*') & (nch () == '/')) == 0)
				if (c == '$') {
					inchar ();
					tog = TRUE;
					if (ch () == '-') {
						tog = FALSE;
						inchar ();
					}
					if (alpha (c = ch ())) {
						inchar ();
						toggle (c, tog);
					}
				} else {
					if (ch () == 0)
						finline ();
					else
						inchar ();
					if (feof (input))
						break;
				}
			inchar ();
			inchar ();
		} else if (an (ch ())) {
			k = 0;
			while (an (ch ())) {
				if (k < NAMEMAX)
					sname[k++] = ch ();
				gch ();
			}
			sname[k] = 0;
			if ( (k = findmac (sname)) ) {
				cpped = 1;
				while (c = macq[k++])
					keepch (c);
			} else {
				k = 0;
				while ( (c = sname[k++]))
					keepch (c);
			}
		} else
			keepch (gch ());
	}
	keepch (0);
	if (mptr >= MPMAX)
		error ("line too long");
	lptr = mptr = 0;
	while ((line[lptr++] = mline[mptr++]));
	lptr = 0;
	return(cpped);
}

int keepch (char c)
{
	mline[mptr] = c;
	if (mptr < MPMAX)
		mptr++;
	return (c);
}

void defmac(char *s)
{
	kill();
	strcpy(line, s);
	addmac();
}

void addmac (void)
{
	char	sname[NAMESIZE];
	int	k;
	int	mp;

	if (!symname (sname)) {
		illname ();
		kill ();
		return;
	}
	if ((mp = findmac(sname))) {
		error("Duplicate define");
		delmac(mp);
	}
	k = 0;
	while (putmac (sname[k++]));
	while ( (ch () == ' ') | (ch () == 9) )
		gch ();
	while (putmac (gch ()));
	if (macptr >= MACMAX)
		error ("macro table full");
}

void delmac(int mp) 
{
	--mp; --mp;	/* step over previous null */
	while (mp >= 0 && macq[mp]) macq[mp--] = '%';
}
	

int putmac (char c)
{
	macq[macptr] = c;
	if (macptr < MACMAX)
		macptr++;
	return (c);
}

int findmac (char *sname)
{
	int	k;

	k = 0;
	while (k < macptr) {
		if (astreq (sname, macq + k, NAMEMAX)) {
			while (macq[k++]);
			return (k);
		}
		while (macq[k++]);
		while (macq[k++]);
	}
	return (0);
}

void toggle (char name, int onoff)
{
	switch (name) {
	case 'C':
		ctext = onoff;
		break;
	}
}

/* expr code, originally from expr.c */

void expression (int comma)
{
	int	lval[3];

	do {
		if (heir1 (lval))
			rvalue (lval);
		if (!comma)
			return;
	} while (match (","));
}

int heir1 (int lval[])
{
	int	k, lval2[3];
	char	fc;

	k = heir1a (lval);
	if (match ("=")) {
		if (k == 0) {
			needlval ();
			return (0);
		}
		if (lval[1])
			gpush ();
		if (heir1 (lval2))
			rvalue (lval2);
		store (lval);
		return (0);
	} else
	{	
		fc = ch();
		if  (match ("-=") ||
		    match ("+=") ||
		    match ("*=") ||
		    match ("/=") ||
		    match ("%=") ||
		    match (">>=") ||
		    match ("<<=") ||
		    match ("&=") ||
		    match ("^=") ||
		    match ("|=")) {
			if (k == 0) {
				needlval ();
				return (0);
			}
			if (lval[1])
				gpush ();
			rvalue (lval);
			gpush ();
			if (heir1 (lval2))
				rvalue (lval2);
			switch (fc) {
				case '-':	{
					if (dbltest(lval,lval2))
						gaslint();
					gsub();
					result (lval, lval2);
					break;
				}
				case '+':	{
					if (dbltest(lval,lval2))
						gaslint();
					gadd (lval,lval2);
					result(lval,lval2);
					break;
				}
				case '*':	gmult (); break;
				case '/':	gdiv (); break;
				case '%':	gmod (); break;
				case '>':	gasr (); break;
				case '<':	gasl (); break;
				case '&':	gand (); break;
				case '^':	gxor (); break;
				case '|':	gor (); break;
			}
			store (lval);
			return (0);
		} else
			return (k);
	}
}

int heir1a (int lval[])
{
	int	k, lval2[3], lab1, lab2;

	k = heir1b (lval);
	blanks ();
	if (ch () != '?')
		return (k);
	if (k)
		rvalue (lval);
	FOREVER
		if (match ("?")) {
			testjump (lab1 = getlabel (), FALSE);
			if (heir1b (lval2))
				rvalue (lval2);
			jump (lab2 = getlabel ());
			printlabel (lab1);
			col ();
			nl ();
			blanks ();
			if (!match (":")) {
				error ("missing colon");
				return (0);
			}
			if (heir1b (lval2))
				rvalue (lval2);
			printlabel (lab2);
			col ();
			nl ();
		} else
			return (0);
}

int heir1b (int lval[])
{
	int	k, lval2[3], lab;

	k = heir1c (lval);
	blanks ();
	if (!sstreq ("||"))
		return (k);
	if (k)
		rvalue (lval);
	FOREVER
		if (match ("||")) {
			testjump (lab = getlabel (), TRUE);
			if (heir1c (lval2))
				rvalue (lval2);
			printlabel (lab);
			col ();
			nl ();
			gbool();
		} else
			return (0);
}

int heir1c (int lval[])
{
	int	k, lval2[3], lab;

	k = heir2 (lval);
	blanks ();
	if (!sstreq ("&&"))
		return (k);
	if (k)
		rvalue (lval);
	FOREVER
		if (match ("&&")) {
			testjump (lab = getlabel (), FALSE);
			if (heir2 (lval2))
				rvalue (lval2);
			printlabel (lab);
			col ();
			nl ();
			gbool();
		} else
			return (0);
}

int heir2 (int lval[])
{
	int	k, lval2[3];

	k = heir3 (lval);
	blanks ();
	if ((ch() != '|') | (nch() == '|') | (nch() == '='))
		return (k);
	if (k)
		rvalue (lval);
	FOREVER {
		if ((ch() == '|') & (nch() != '|') & (nch() != '=')) {
			inbyte ();
			gpush ();
			if (heir3 (lval2))
				rvalue (lval2);
			gor ();
			blanks();
		} else
			return (0);
	}
}

int heir3 (int lval[])
{
	int	k, lval2[3];

	k = heir4 (lval);
	blanks ();
	if ((ch () != '^') | (nch() == '='))
		return (k);
	if (k)
		rvalue (lval);
	FOREVER {
		if ((ch() == '^') & (nch() != '=')){
			inbyte ();
			gpush ();
			if (heir4 (lval2))
				rvalue (lval2);
			gxor ();
			blanks();
		} else
			return (0);
	}
}

int heir4 (int lval[])
{
	int	k, lval2[3];

	k = heir5 (lval);
	blanks ();
	if ((ch() != '&') | (nch() == '|') | (nch() == '='))
		return (k);
	if (k)
		rvalue (lval);
	FOREVER {
		if ((ch() == '&') & (nch() != '&') & (nch() != '=')) {
			inbyte ();
			gpush ();
			if (heir5 (lval2))
				rvalue (lval2);
			gand ();
			blanks();
		} else
			return (0);
	}
}

int heir5 (int lval[])
{
	int	k, lval2[3];

	k = heir6 (lval);
	blanks ();
	if (!sstreq ("==") &
	    !sstreq ("!="))
		return (k);
	if (k)
		rvalue (lval);
	FOREVER {
		if (match ("==")) {
			gpush ();
			if (heir6 (lval2))
				rvalue (lval2);
			geq ();
		} else if (match ("!=")) {
			gpush ();
			if (heir6 (lval2))
				rvalue (lval2);
			gne ();
		} else
			return (0);
	}
}

int heir6 (int lval[])
{
	int	k, lval2[3];

	k = heir7 (lval);
	blanks ();
	if (!sstreq ("<") &&
	    !sstreq ("<=") &&
	    !sstreq (">=") &&
	    !sstreq (">"))
		return (k);
	if (sstreq ("<<") || sstreq (">>"))
		return (k);
	if (k)
		rvalue (lval);
	FOREVER {
		if (match ("<=")) {
			gpush ();
			if (heir7 (lval2))
				rvalue (lval2);
			if (lval[2] || lval2[2]) {
				gule ();
				continue;
			}
			gle ();
		} else if (match (">=")) {
			gpush ();
			if (heir7 (lval2))
				rvalue (lval2);
			if (lval[2] || lval2[2]) {
				guge ();
				continue;
			}
			gge ();
		} else if ((sstreq ("<")) &&
			   !sstreq ("<<")) {
			inbyte ();
			gpush ();
			if (heir7 (lval2))
				rvalue (lval2);
			if (lval[2] || lval2[2]) {
				gult ();
				continue;
			}
			glt ();
		} else if ((sstreq (">")) &&
			   !sstreq (">>")) {
			inbyte ();
			gpush ();
			if (heir7 (lval2))
				rvalue (lval2);
			if (lval[2] || lval2[2]) {
				gugt ();
				continue;
			}
			ggt ();
		} else
			return (0);
		blanks ();
	}
}

int heir7 (int lval[])
{
	int	k, lval2[3];

	k = heir8 (lval);
	blanks ();
	if (!sstreq (">>") &&
	    !sstreq ("<<") || sstreq(">>=") || sstreq("<<="))
		return (k);
	if (k)
		rvalue (lval);
	FOREVER {
		if (sstreq(">>") && ! sstreq(">>=")) {
			inbyte(); inbyte();
			gpush ();
			if (heir8 (lval2))
				rvalue (lval2);
			gasr ();
		} else if (sstreq("<<") && ! sstreq("<<=")) {
			inbyte(); inbyte();
			gpush ();
			if (heir8 (lval2))
				rvalue (lval2);
			gasl ();
		} else
			return (0);
		blanks();
	}
}

int heir8 (int lval[])
{
	int	k, lval2[3];

	k = heir9 (lval);
	blanks ();
	if ( (ch () != '+') & (ch () != '-') | (nch() == '=') )
		return (k);
	if (k)
		rvalue (lval);
	FOREVER {
		if (match ("+")) {
			gpush ();
			if (heir9 (lval2))
				rvalue (lval2);
			/* if left is pointer and right is int, scale right */
			if (dbltest (lval, lval2))
				gaslint ();
			/* will scale left if right int pointer and left int */
			gadd (lval,lval2);
			result (lval, lval2);
		} else if (match ("-")) {
			gpush ();
			if (heir9 (lval2))
				rvalue (lval2);
			/* if dbl, can only be: pointer - int, or
						pointer - pointer, thus,
				in first case, int is scaled up,
				in second, result is scaled down. */
			if (dbltest (lval, lval2))
				gaslint ();
			gsub ();
			/* if both pointers, scale result */
			if ((lval[2] == CINT) && (lval2[2] == CINT)) {
				gasrint(); /* divide by intsize */
			}
			result (lval, lval2);
		} else
			return (0);
	}
}

int heir9 (int lval[])
{
	int	k, lval2[3];

	k = heir10 (lval);
	blanks ();
	if (((ch () != '*') && (ch () != '/') &&
		(ch () != '%')) || (nch() == '='))
		return (k);
	if (k)
		rvalue (lval);
	FOREVER {
		if (match ("*")) {
			gpush ();
			if (heir10 (lval2))
				rvalue (lval2);
			gmult ();
		} else if (match ("/")) {
			gpush ();
			if (heir10 (lval2))
				rvalue (lval2);
			gdiv ();
		} else if (match ("%")) {
			gpush ();
			if (heir10 (lval2))
				rvalue (lval2);
			gmod ();
		} else
			return (0);
	}
}

int heir10 (int lval[])
{
	int	k;
	char	*ptr;

	if (match ("++")) {
		if ((k = heir10 (lval)) == 0) {
			needlval ();
			return (0);
		}
		if (lval[1])
			gpush ();
		rvalue (lval);
		ginc (lval);
		store (lval);
		return (0);
	} else if (match ("--")) {
		if ((k = heir10 (lval)) == 0) {
			needlval ();
			return (0);
		}
		if (lval[1])
			gpush ();
		rvalue (lval);
		gdec (lval);
		store (lval);
		return (0);
	} else if (match ("-")) {
		k = heir10 (lval);
		if (k)
			rvalue (lval);
		gneg ();
		return (0);
	} else if (match ("~")) {
		k = heir10 (lval);
		if (k)
			rvalue (lval);
		gcom ();
		return (0);
	} else if (match ("!")) {
		k = heir10 (lval);
		if (k)
			rvalue (lval);
		glneg ();
		return (0);
	} else if (ch()=='*' && nch() != '=') {
		inbyte();
		k = heir10 (lval);
		if (k)
			rvalue (lval);
		if ((ptr = (char *) lval[0]))
			lval[1] = ptr[TYPE];
		else
			lval[1] = CINT;
		lval[2] = 0;  /* flag as not pointer or array */
		return (1);
	} else if (ch()=='&' && nch()!='&' && nch()!='=') {
		inbyte();
		k = heir10 (lval);
		if (k == 0) {
			error ("illegal address");
			return (0);
		}
		ptr = (char *)lval[0];
		lval[2] = ptr[TYPE];
		if (lval[1])
			return (0);
		/* global and non-array */
		immed ();
		prefix ();
		outstr (ptr = (char *) lval[0]);
                col();
		outbyte('\''); /* Added 14/01/01 */
		nl ();
		lval[1] = ptr[TYPE];
		ol ("movwf _primary"); /* added */
		return (0);
	} else {
		k = heir11 (lval);
		if (match ("++")) {
			if (k == 0) {
				needlval ();
				return (0);
			}
			if (lval[1])
				gpush ();
			rvalue (lval);
			ginc (lval);
			store (lval);
			gdec (lval);
			return (0);
		} else if (match ("--")) {
			if (k == 0) {
				needlval ();
				return (0);
			}
			if (lval[1])
				gpush ();
			rvalue (lval);
			gdec (lval);
			store (lval);
			ginc (lval);
			return (0);
		} else
			return (k);
	}
}

int heir11 (int *lval)
{
	int	k;
	char	*ptr;

	k = primary (lval);
	ptr = (char *) lval[0];
	blanks ();
	if ((ch () == '[') | (ch () == '('))
		FOREVER {
			if (match ("[")) {
				if (ptr == 0) {
					error ("can't subscript");
					junk ();
					needbrack ("]");
					return (0);
				} else if (ptr[IDENT] == POINTER)
					rvalue (lval);
				else if (ptr[IDENT] != ARRAY) {
					error ("can't subscript");
					k = 0;
				}
				gpush ();
				expression (YES);
				needbrack ("]");
				if (ptr[TYPE] == CINT)
					gaslint ();
				gadd (NULL,NULL);
				lval[0] = 0;
				lval[1] = ptr[TYPE];
				k = 1;
			} else if (match ("(")) {
				if (ptr == 0)
					callfunction (0);
				else if (ptr[IDENT] != FUNCTION) {
					rvalue (lval);
					callfunction (0);
				} else
					callfunction (ptr);
				k = lval[0] = 0;
			} else
				return (k);
		}
	if (ptr == 0)
		return (k);
	if (ptr[IDENT] == FUNCTION) {
		immed ();
		prefix ();
		outstr (ptr);
        col();
		outbyte('\''); /* Added 14/01/01 */
		nl ();
		ol ("movwf _primary"); /* added */
		return (0);
	}
	return (k);
}

/**************************************************************************/

int galign(int t)
{
	if (TRACE)
	   fprintf(output,";galign(%d)\n",t);
	return(t);
}

/*
 *      return size of an integer
 */
int intsize(void) {
	return(INTSIZE);
}

/*
 *      return offset of ls byte within word
 *      (ie: 8080 & pdp11 is 0, 6809 is 1, 360 is 3)
 */

int byteoff(void) {
	return(BYTEOFF);
}

/*
 *      Output internal generated label prefix
 */
void olprfix(void) {
	outbyte('_');
}

/*
 *      Output a label definition terminator
 */
void col (void)
{
	outbyte ('_');
}

/*
 *      begin a comment line for the assembler
 *
 */
void comment (void )
{
	outbyte (';');
}

/*
 *      Emit user label prefix
 */
void prefix (void )
{
       /* outbyte('_'); */
}


/*
 *      print any assembler stuff needed after all code
 *
 */
void trailer (void )
{
	if (TRACE)
	  fprintf(output,"\n;trailer()\n");

	ol ("END");
	nl();
}

/*
 *      function prologue
 */
void prologue (void )
{
	if (TRACE)
	   fprintf(output,";prologue()\n");
	ol("\n\n; Begin Function \n");
	ol("\n");
}

/*
 *      text (code) segment
 */
void gtext (void )
{
	if (TRACE)
	   fprintf(output,";gtext()\n");
	ol ("\n; ****************** code segment ***********************");
	outstr("\tORG  0x17F ;processor reset vector\n");
	outstr("\tgoto main_\n");
	outstr("\tORG  0x000\n");
}

/*
 *      data segment
 */
void gdata (void )
{
	if (TRACE) fprintf(output,";gdata()\n");

    if (M_lib==TRUE) 
	{
		outstr("\n;******* need mult/div standard library ********\n");
        ol("\n\t#include <mlibpic.h>\n");
	}

    if (S_lib==TRUE)
	{
        outstr("\n;******* need shift/sub standard library ********\n");
         
		if(TargetCore==12)
		{
	  		ol("\n\t#include <sslib12b.h>\n");
		}
		else if(TargetCore==14)
		{
	  		ol("\n\t#include <sslib14b.h>\n");
		}
		else 
		{
	  		ol("\n\t#include <sslib16b.h>\n");
		}
		  
    }

    if (G_lib==TRUE) 
	{
		outstr("\n;******* need compare standard library ********\n");
		ol("\n\t#include <glibpic.h>\n");
    }

	outstr("\n;******* need standard stack library ********\n");
	ol("\n\t#include <stacklib.h>\n");
    	
	outstr("\n\n;************** VARIABLE DEFINITIONS *******************\n\n");
	outstr(";Registers needed by code generator\n");
	outstr("_primary      EQU      0x07\n");
	outstr("_secondary    EQU      0x08\n");
	outstr("_temp         EQU      0x09\n");
	outstr("_stackptr     EQU      0x0a\n");
	outstr("_fr0          EQU      0x0b\n");
	outstr("_fr4          EQU      0x0c\n");
	outstr(";Registers used by program\n");
}

/*
 *  Output the variable symbol at scptr as an extrn or a public
 */
void ppubext(char *scptr)
{
	if (TRACE)
	  fprintf(output,";ppubext(%s)\n",scptr);
	/******
	if (cptr[STORAGE] == STATIC) return;
	ot (scptr[STORAGE] == EXTERN ? "extrn\t" : "public\t");
	prefix ();
	outstr (scptr);
	nl();
	*******/
}

/*
 * Output the function symbol at scptr as an extrn or a public
 */
void fpubext(char *scptr)
{
	if (TRACE)
	   fprintf(output,";ppubext(%s)\n",scptr);
	/*******
	if (scptr[STORAGE] == STATIC) return;
	ot (scptr[OFFSET] == FUNCTION ? "public\t" : "extrn\t");
	prefix ();
	outstr (scptr);
	nl ();
	********/
}

/*
 *  Output a decimal number to the assembler file
 */
void onum(int num)
{
	outdec(num);
}


/*
 *      fetch a static memory cell into the primary register
 */
void getmem (char *sym)
{
	if (TRACE)
	   fprintf(output,";getmem(%s)\n",sym);
	if ((sym[IDENT] != POINTER) &
	    (sym[TYPE] == CCHAR)) 
	{
		ot ("movf ");
		outstr (sym + NAME);
		col();
		ot (", 0");
		nl();
		ol ("movwf _primary");
		
		/** Changed From ***
		ot ("mov _primary, ");
		outstr (sym + NAME);
		col();
		nl ();
		*******************/
		/* gcall ("?sxt"); */
	} 
	else 
	{
		outstr(CHAR_WARNING);
		ot ("movf ");
		outstr (sym + NAME);
		col();
		ot (", 0");
		nl();
		ol ("movwf _primary");
		
		/** Changed From ***
		ot ("mov _primary, ");
		outstr (sym + NAME);
		nl ();
		*******************/
	}
}

/*
 *      fetch the address of the specified symbol into the primary register
 *
 */
void getloc (char *sym)
{
	if (TRACE)
	   fprintf(output,";getloc(%s)\n",sym);
	
	immed();
	
	if (sym[STORAGE] == LSTATIC) 
	{
		printlabel(glint(sym));
		outbyte('\''); /* Added 14/01/01 */
		nl();
	} 
	else 
	{
		outdec (glint(sym) - stkp ); /**/
		outbyte('\''); /* Added 14/01/01 */
		nl ();
		/* outstr (";*****dad sp****\n"); */
		ol ("movf _stackptr, 0"); /* added */
		ol ("addwf _primary, 1"); /* changed from "add _primary, _stackptr" */
	}
}

/*
 *      store the primary register into the specified static memory cell
 *
 */
void putmem (char *sym)
{
	if (TRACE)
	   fprintf(output,";putmem(%s)\n",sym);
	
	if ((sym[IDENT] != POINTER) &
	    (sym[TYPE] == CCHAR)) 
	{
		ol ("movf _primary, 0");
		ot ("movwf ");
		outstr (sym + NAME);
		col();
		/** Changed From ***
		ot ("mov ");
		outstr (sym + NAME);
		col();
		ot (", _primary");
		*******************/
	} 
	else 
	{
		outstr(CHAR_WARNING);
		ol ("movf _primary, 0");
		ot ("movwf ");
		outstr (sym + NAME);
		col();
		/** Changed From ***
		outstr(CHAR_WARNING);
		ot ("mov ");
		outstr (sym + NAME);
		col();
		ot (", _primary");
		*******************/
	}
	nl ();
}

/*
 *      store the specified object type in the primary register
 *      at the address on the top of the stack
 *
 */
void putstk (char typeobj)
{
	if (TRACE)
	   fprintf(output,";putstk(%d)\n",typeobj);
	gpop ();
	if (typeobj == CCHAR) 
	{
		gcall("_putstk");
	}
	else 
	{
		outstr(CHAR_WARNING);
        gcall("_putstk");
	}
}

/*
 *      fetch the specified object type indirect through the primary
 *      register into the primary register
 *
 */
void indirect (char typeobj)
{
	if (TRACE)
	   fprintf(output,";indirect(%d)\n",typeobj);
	
	if (typeobj == CCHAR) 
	{
		gcall("_indr");
	}
	else 
	{
		outstr(CHAR_WARNING);
        gcall("_indr");
	}
}

/*
 *      swap the primary and secondary registers
 *
 */
void swap (void)
{
	if (TRACE)
	   fprintf(output,";swap\n");
    gcall("_swap");
}

/*
 *      print partial instruction to get an immediate value into
 *      the primary register
 *
 */

void immed (void)
{
	if (TRACE)
	   fprintf(output,";immed()\n");
	ot ("movlw D\'"); /* end ' finished of latter */
	/* Changed from ot ("mov _primary, #"); */
	/* primary part added in primary.c */
}

/* Function never used ignore ********
immed_nopound ()
{
	if (TRACE)
	   fprintf(output,";immed()\n");
	ot (";mov _primary, "); 
}
*************************************/

/*
 *      push the primary register onto the stack
 *
 */
void gpush (void)
{
	if (TRACE)
	   fprintf(output,";gpush\n");
    gcall("_push");
	stkp = stkp - INTSIZE;
}

/*
 *      pop the top of the stack into the secondary register
 *
 */
void gpop (void)
{
	if (TRACE)
	   fprintf(output,";gpop\n");
    gcall("_pop");
	stkp = stkp + INTSIZE;
}

/*
 *      swap the primary register and the top of the stack
 *
 */
void swapstk (void)
{
	if (TRACE)
	  fprintf(output,";swapstk\n");
	gcall("_swaps");
}

/*
 *      call the specified subroutine name
 *
 */
void gcall (char *sname)
{
	if (TRACE)
	   fprintf(output,";gcall\n",sname);
	ot ("call ");
	outstr (sname);
	col();
	nl ();
}

/*
 *      return from subroutine
 *
 */
void gret (void)
{
	if (TRACE)
	   fprintf(output,";gret\n");
	ol ("retlw 0"); /* changed from "ret" */
}

/*
 *      perform subroutine call to value on top of stack
 *
 */
void callstk (void )
{
	if (TRACE)
	   fprintf(output,";callstk\n");
	outstr( ERRMSG );
	return;
/******
	immed ();
	outstr ("$+5");
	nl ();
	swapstk ();
	ol ("pchl");
	stkp = stkp + INTSIZE;
******/
}

/*
 *      jump to specified internal label number
 *
 */
void jump (int label)
{
	if (TRACE)
	   fprintf(output,";jump(%d)\n",label);
	ot ("goto "); /* changed from "jmp " */
	printlabel (label);
	col();
	nl ();
}

/*
 *      test the primary register and jump if false to label
 *
 */
void testjump (int label, int ft)
{
	if (TRACE)
	   fprintf(output,";testjump(%d,%d)\n",label,ft);
	ol ("movf _primary, 0"); /* changed from "mov W, _primary" */
	if (ft)
	{
		ol ("btfss 3,2");
		ot ("goto "); /* changed from "jnz " */
	}
	else
	{
		ol ("btfsc 3,2");
		ot ("goto "); /* changed from "jz " */
	}
	printlabel (label);
	col();
	nl ();
}

/*
 *      print pseudo-op  to define a byte
 *
 */
void defbyte (void )
{
	if (TRACE)
	   fprintf(output,";defbyte()\n");
	ot ("db\t");
}

/*
 *      print pseudo-op to define storage
 *
 */
void defstorage (void )
{
	if (TRACE)
	   fprintf(output,";defstorage()\n");
	ot ("EQU\t");
}

/*
 *      print pseudo-op to define a word
 *
 */
void defword (void )
{
	if (TRACE)
	   fprintf(output,";defword()\n");
	ot ("dw\t");
}

/*
 *      modify the stack pointer to the new value indicated
 *
 */
int modstk (int newstkp)
{
	int k;
    char buffer[50];

	if (TRACE)
	   fprintf(output,";modstk(%d)\n",newstkp);

	k = galign(newstkp - stkp);

	if (k == 0) 
	{
	   return (newstkp);
	}
	/* forget about stack alignment */
	if (k > 0) 
	{
		sprintf(buffer,"movlw D\'%d\'\n\taddwf _stackptr, 1",k); /* changed from "add _stackptr, #%d" */
        ol(buffer);
		return (newstkp);
	}
	else 
	{
        k=-k;
		sprintf(buffer,"movlw D\'%d\'\n\tsubwf _stackptr, 1",k); /* changed from "sub _stackptr, #%d" */
        ol(buffer);
		return (newstkp);
	}
}

/*
 *      multiply the primary register by INTSIZE
 */
void gaslint (void )
{
	if (TRACE)
	   fprintf(output,";gaslint()\n");
	/* ol ("dad\th"); */
}


/*
 *      divide the primary register by INTSIZE
 */
void gasrint(void)
{
	if (TRACE)
	  fprintf(output,";gasrint()\n");
	return;
#ifdef INTEGERS
	gpush();        /* push primary in prep for gasr */
	immed ();
	onum (1);
	outbyte('\''); /* Added 14/01/01 */
	nl ();
	ot ("movwf _primary"); /* added */
	gasr ();  /* divide by two */
#endif
}

/*
 *      Case jump instruction
 */

void gjcase( int label )
{
	if (TRACE)
	   fprintf(output,";gjcase()\n");
	jump(label);
}

/* this is a real hack */
/* output inline code for case statement */

void outcase( int typ, int value, int label )
{
    char buffer[50];

    if (TRACE)
       fprintf(output,";outcase()\n");
    
	if (typ==CASE) 
	{
      	sprintf(buffer,"movlw D\'%d\'\nsubwf _primary, 0\nbtfsc 3, 2\ngoto _%d_",value,label); /* changed from "cje _primary,#%d,_%d_" */
      	ol(buffer);
    }
    else
		if (typ==DEFAULT) 
		{
			sprintf(buffer,"goto _%d_",label); /* changed from "jmp _%d_" */
			ol(buffer);
		}
		else
			outstr(ERRMSG);
}

/*
 *      add the primary and secondary registers
 *      if lval2 is int pointer and lval is not, scale lval
 */

void gadd (int *lval,int *lval2)
{
	if (TRACE)
	   fprintf(output,";gadd(%d, %d)\n",*lval,*lval2);
	gpop ();
	if (dbltest (lval2, lval)) 
	{
		swap ();
		gaslint ();
		swap ();
	}
	ol ("movf _secondary, 0"); /* added */
	ol ("addwf _primary, 1"); /* changed from "add _primary, _secondary" */
}

/*
 *      subtract the primary register from the secondary
 *      P=S-P;
 */
void gsub (void )
{
	if (TRACE)
	  fprintf(output,";gsub()\n");
	gpop ();
    S_lib=TRUE;
    gcall("_sub");
}

/*
 *      multiply the primary and secondary registers
 *      (result in primary)
 *
 */
void gmult (void )
{
	if (TRACE)
	   fprintf(output,";gmult()\n");
    M_lib=TRUE;
	gpop();
	gcall ("_mul");
}

/*
 *      divide the secondary register by the primary
 *      (quotient in primary, remainder in secondary)
 *
 */
void gdiv (void )
{
	if (TRACE)
	   fprintf(output,";gdiv()\n");
    M_lib=TRUE;
	gpop();
	gcall ("_div");
}

/*
 *      compute the remainder (mod) of the secondary register
 *      divided by the primary register
 *      (remainder in primary, quotient in secondary)
 *
 */

void gmod (void )
{
	if (TRACE)
	   fprintf(output,";gmod()\n");
    M_lib=TRUE;
	gdiv ();
	swap ();
}

/*
 *      inclusive 'or' the primary and secondary registers
 *
 */
void gor (void )
{
	if (TRACE)
	   fprintf(output,";gor()\n");
	gpop();
	ol ("movf _secondary, 0");
	ol ("iorwf _primary, 1"); /* changed from "or _primary, _secondary" */
}

/*
 *      exclusive 'or' the primary and secondary registers
 *
 */
void gxor (void )
{
	if (TRACE)
	  fprintf(output,";gxor()\n");
	gpop();
	ol ("movf _secondary, 0"); /* changed from "mov W, _secondary" */
	ol ("xorwf _primary, W"); /* changed from "xor _primary, W" */
}

/*
 *      'and' the primary and secondary registers
 *
 */
void gand (void )
{
	if (TRACE)
	   fprintf(output,";gand()\n");
	gpop();
	ol ("movf _secondary, 0"); /* added */  
	ol ("andwf _primary, 1"); /* changed from "and _primary,_secondary" */ 
}


/*
 *      arithmetic shift right the secondary register the number of
 *      times in the primary register
 *      (results in primary register)
 *
 */
void gasr (void )
{
	if (TRACE)
	   fprintf(output,";gasr()\n");
	gpop();
    S_lib=TRUE;
    gcall ("_asr");
}

/*
 *      arithmetic shift left the secondary register the number of
 *      times in the primary register
 *      (results in primary register)
 *
 */
void gasl (void )
{
	if (TRACE)
	  fprintf(output,";gasl()\n");
	gpop ();
    S_lib=TRUE;
	gcall ("_asl");
}

/*
 *      two's complement of primary register
 *
 */
void gneg (void )
{
	if (TRACE)
	   fprintf(output,";gneg()\n");
	ol ("comf _primary,1"); /* added */
	ol ("incf _primary,1"); /* changed from "neg _primary" */
}

/*
 *      logical complement of primary register
 *
 */
void glneg (void )
{
	if (TRACE)
	  fprintf(output,";glneg()\n");
     /* gcall ("_logneg");  */
	ol ("movlw D\'1\'"); /* changed from "mov W, #1" */
	ol ("xorwf _primary,1"); /* changed from "xor _primary, W" */
}

/*
 *      one's complement of primary register
 *
 */
void gcom (void )
{
	if (TRACE)
	  fprintf(output,";gcom()\n");
	ol ("not _primary");
}

/*
 *      Convert primary value into logical value (0 if 0, 1 otherwise)
 *
 */
void gbool (void )
{
	if (TRACE)
	   fprintf(output,";gbool()\n");
    G_lib=TRUE;
	gcall ("_bool");
}

/*
 *      increment the primary register by 1 if char, INTSIZE if
 *      int
 */
void ginc (int lval[])
{
	if (TRACE)
	   fprintf(output,";ginc()\n");
	ol ("incf _primary,1");
	if (lval[2] == CINT) 
	{
		outstr( ERRMSG );
		ol ("incf _primary,1");
		ol ("incf _primary,1");
	}

}

/*
 *      decrement the primary register by one if char, INTSIZE if
 *      int
 */
void gdec (int lval[])
{
	if (TRACE) fprintf(output,";gdec()\n");
	ol ("decf _primary,1");
	if (lval[2] == CINT) 
	{
		outstr( ERRMSG );
		ol("decf _primary,1");
		ol("decf _primary,1");
	}
}

/*
 *      following are the conditional operators.
 *      they compare the secondary register against the primary register
 *      and put a literl 1 in the primary if the condition is true,
 *      otherwise they clear the primary register
 *
 */

/*
 *      equal
 *
 */
void geq (void )
{
	if (TRACE)
	   fprintf(output,";geq()\n");
	gpop();
    G_lib=TRUE;
    gcall("_geq");

}

/*
 *      not equal
 *
 */
void gne (void )
{
	if (TRACE)
	  fprintf(output,";gne()\n");
	gpop();
    G_lib=TRUE;
    gcall("_gne");

}

/* ******  signed chars are not handled yet, use unsigned versions ******/
/*
 *      less than (signed)
 *
 */

void glt (void )
{
	if (TRACE)
	   fprintf(output,";glt()\n");
	outstr( WARNING );
	gpop();
    G_lib=TRUE;
    gcall( "_glt");
}


/*
 *      less than or equal (signed)
 *
 */
void gle (void )
{
	if (TRACE)
	   fprintf(output,";gle()\n");
	outstr( WARNING );
	gpop();
        G_lib=TRUE;
        gcall("_gle");
}

/*
 *      greater than (signed)
 *
 */
void ggt (void )
{
	if (TRACE)
	   fprintf(output,";ggt()\n");
	outstr( WARNING );
	gpop();
    G_lib=TRUE;
    gcall("_ggt");
}

/*
 *      greater than or equal (signed)
 *
 */
void gge (void )
{
	if (TRACE)
	   fprintf(output,";gge()\n");
	outstr( WARNING );
	gpop();
    G_lib=TRUE;
    gcall ("_gge");
}

/*
 *      less than (unsigned)
 *
 */
void gult (void )
{
	if (TRACE)
	   fprintf(output,";gult()\n");
	gpop();
    G_lib=TRUE;
	gcall ("_gult");
}

/*
 *      less than or equal (unsigned)
 *
 */
void gule (void )
{
	if (TRACE)
	  fprintf(output,";gule()\n");
	gpop();
    G_lib=TRUE;
	gcall ("_gule");
}

/*
 *      greater than (unsigned)
 *
 */
void gugt (void )
{
	if (TRACE)
	   fprintf(output,";gugt()\n");
	gpop();
    G_lib=TRUE;
	gcall ("_gugt");
}

/*
 *      greater than or equal (unsigned)
 *
 */
void guge (void )
{
	if (TRACE)
	   fprintf(output,";guge()\n");
	gpop();
    G_lib=TRUE;
	gcall ("_guge");
}

/*      Squirrel away argument count in a register that modstk
	doesn't touch.
*/

void gnargs(int d)
{
	if (TRACE)
	   fprintf(output,";gnargs(%d)\n",d);
	ot (";;(# args passed) mov W, D'"); /*????????????*/
	onum(d);
	outbyte('\''); /* Added 14/01/01 */
	nl ();
}

int assemble(char *s)
{
	if (TRACE)
	   fprintf(output,";assemble(%s)\n",s);
#ifdef  ASNM
	char buf[100];
	strcpy(buf, ASNM);
	strcat(buf, " ");
	strcat(buf, s);
	buf[strlen(buf)-1] = 's';
	return(system(buf));
#else
	return(0);
#endif
}

int link(void )
{
#ifdef LDNM
	fputs("I dont know how to link files yet\n", stderr);
#else
	return(0);
#endif
}





/* main code, originally from main.c */

int main (int argc, int *argv)
{
	char	*p,*bp;
	int tempbyte1; 
	int smacptr;
	macptr = 0;
	ctext = 0;
	argc--; argv++;
	errs = 0;
	aflag = 1;
    TRACE=0;

    inittrace();
	
	while ( (p = (char *) *argv++) )
		if (*p == '-') while (*++p)		// keep increase byte position until a '-' is found
			switch(*p)					// switch to character found after the '-'
			{
				
				case 't': case 'T':		// This options gives the c source code, then it displays the assembler after it
					ctext = 1;
					break;
				
				case 's': case 'S':		// ?? -- does nothing?
					sflag = 1;
					break;
				
				case 'b': case 'B':		// ?? -- does nothing?
					bflag = 1;
					break;
				
				case 'a': case 'A':		// ?? -- does nothing?	
					aflag = 0;
					break;
				
				case 'c': case 'C':		// set the core, options are -c=12, -c=14, -c=16
					bp = ++p;			// '=' is set to bp
					while (*p == '=') p++;
					
					sscanf(p,"%d",&tempbyte1);

					if(tempbyte1==12)  
					{
						printf("Selected Core 12 Bits\n");
						TargetCore=12;
					}
					else if(tempbyte1==14)  
					{
						printf("Selected Core 14 Bits\n");
						TargetCore=14;
					}
					else if(tempbyte1==16)  
					{
						printf("Selected Core 16 Bits\n");
						TargetCore=16;
					}
					else
					{
						usage();
					}
					
					while (*p) p++;
					p--;
					break;
                
				case 'd': case 'D':		// ?? -- does nothing?
					bp = ++p;
					if (!*p) usage();
					while (*p && *p != '=') p++;
					if (*p == '=') *p = '\t';
					while (*p) p++;
					p--;
					defmac(bp);
					break;
                
				case 'r': case 'R': TRACE=1;	// Used for debugging, each call made in the program is outputted
                    break;
				
				default:
					usage();
			}
			else break;

	if(TargetCore==0)
	{
		// No Core selected, display message saying core must be choosen
		printf("No Core Selected, Please Choose Core\n");
		usage();
	}


	smacptr = macptr;
	if (!p)
		usage();
	while (p) {
		errfile = 0;
		if (ftypeof(p) == 'c') {

			if (!openin (p))
				return(0);
			if (!openout ())
				return(0);

			glbptr = STARTGLB;
			locptr = STARTLOC;
			wsptr = ws;
			inclsp =
			iflevel =
			skiplevel =
			swstp =
			litptr =
			stkp =
			errcnt =
			ncmp =
			lastst =
			quote[1] =
			0;
			macptr = smacptr;
			input2 = NULL;
			quote[0] = '"';
			cmode = 1;
			glbflag = 1;
			nxtlab = 0;
			litlab = getlabel ();
			defmac("end\tmemory");
			addglb("memory", ARRAY, CCHAR, 0, EXTERN);
			addglb("stack", ARRAY, CCHAR, 0, EXTERN);
			rglbptr = glbptr;
			addglb ("etext", ARRAY, CCHAR, 0, EXTERN);
			addglb ("edata", ARRAY, CCHAR, 0, EXTERN);
			defmac("short\tint");
			initmac();
			/*
			 *	compiler body
			 */
                        /*******
			if (!openin (p))
				return;
			if (!openout ())
				return;
                        **********/
			header ();
			gtext ();
			parse ();
			fclose (input);
			/* gdata ();   imbed lits in code space */
			dumplits ();
                        gdata();
			dumpglbs ();
			errorsummary ();
			trailer ();
			fclose (output);
			pl ("");
			errs = errs || errfile;
#ifndef	NOASLD
		}
		if (!errfile && !sflag)
			errs = errs || assemble(p);
#else
		} else {
			fputs("Don't understand file ", stderr);
			fputs(p, stderr);
			errs = 1;
		}
#endif
		p = (char *) *argv++;
	}
#ifndef	NOASLD
	if (!errs && !sflag && !bflag)
		errs = errs || link();
#endif
        endtrace();
	exit(errs != 0);
}

void FEvers(void )
{
	outstr("\tFront End (PIC Ver 1.0 2/19/95)");
}

void usage(void )
{
	fputs("usage: pic_cc [-R] [-DSYM[=VALUE]] files\n", stderr);
	exit(1);
}

/*
 *	process all input text
 *
 *	at this level, only static declarations, defines, includes,
 *	and function definitions are legal.
 *
 */
void parse (void )
{
	while (!feof (input)) {
		if (amatch ("extern", 6))
			dodcls(EXTERN);
		else if (amatch ("static",6))
			dodcls(STATIC);
		else if (dodcls(PUBLIC)) ;
		else if (match ("#asm"))
			doasm ();
		else if (match ("#include"))
			doinclude ();
		else if (match ("#define"))
			dodefine();
		else if (match ("#undef"))
			doundef();
		else
			newfunc ();
		blanks ();
	}
}

/*
 *		parse top level declarations
	*/

int dodcls(int stclass)
{
	blanks();
	if (amatch("char", 4))
		declglb(CCHAR, stclass);
	else if (amatch("int", 3))
		declglb(CINT, stclass);
	else if (stclass == PUBLIC)
		return(0);
	else
		declglb(CINT, stclass);
	ns ();
	return(1);
}


/*
 *	dump the literal pool
 */
void dumplits (void )
{
	int	j, k;
        char ch;

	if (litptr == 0)
		return;

        outstr("\n; Begin global string table\n");
        outstr("\n_string_table_\n");     /* add a new special label for strings */
        ol("jmp PC+W");
	printlabel (litlab);
	col ();
	k = 0;
	while (k < litptr) {
                ot("retw ");
                outbyte('\'');
		j = 255;
		while (j--) {
                        ch=litq[k++] & 127;
			if ((j == 0) || (k >= litptr) || (ch==0)) {
                                outbyte('\'');
				nl ();
                                ot("retw 0");
                                nl ();
				break;
			}
                        else
                          outbyte(ch);
		}
	}
}

/***************************************************/
#ifdef OLDVER
dumplits ()
{
	int	j, k;

	if (litptr == 0)
		return;
	printlabel (litlab);
	col ();
	k = 0;
	while (k < litptr) {
		defbyte ();
		j = 8;
		while (j--) {
			onum (litq[k++] & 127);
			if ((j == 0) | (k >= litptr)) {
				nl ();
				break;
			}
			outbyte (',');
		}
	}
}
#endif
/***************************************************/


/*
 *	dump all static variables
 */
void dumpglbs (void )
{
	int	j;
	int offset=DEFAULT_VARIABLES_OFFSET;

	if (!glbflag)
		return;
	cptr = rglbptr;
	while (cptr < glbptr) {
		if (cptr[IDENT] != FUNCTION) 
		{
			ppubext(cptr);
			if (cptr[STORAGE] != EXTERN) 
			{
				prefix ();
				outstr (cptr);
				col ();
				defstorage ();
				j = glint(cptr);
				if ((cptr[TYPE] == CINT) || (cptr[IDENT] == POINTER)) j = j * intsize();
				outhexaddr(j+offset); /* Added 14/01/01 changed from ---> onum (j); */
				offset+=j;
				nl ();
			}
		} else {
			fpubext(cptr);
		}
		cptr = cptr + SYMSIZ;
	}
}

/*
 *	report errors
 */
void errorsummary (void )
{
	if (ncmp)
		error ("missing closing bracket");
	nl ();
	comment ();
	outdec (errcnt);
	if (errcnt) errfile = YES;
	outstr (" error(s) in compilation");
	nl ();
	comment();
	ot("literal pool:");
	outdec(litptr);
	nl();
	comment();
	ot("global pool:");
	outdec(glbptr-rglbptr);
	nl();
	comment();
	ot("Macro pool:");
	outdec(macptr);
	nl();
	pl (errcnt ? "Error(s)" : "No errors");
}

int ftypeof(char *s)
{
	s += strlen(s) - 2;
	if (*s == '.')
		return(*(s+1));
	return(' ');
}

