#define	FOREVER	for(;;)
#define	FALSE	0
#define	TRUE	1
#define	NO	0
#define	YES	1

/* miscellaneous */

#define	EOS	0
#define	EOL	10
#define	BKSP	8
#define	CR	13
#define	FFEED	12
#define TAB	9

/* symbol table parameters */

#define	SYMSIZ	14
#define	SYMTBSZ	2800
#define	NUMGLBS	150
#define	STARTGLB	symtab
#define	ENDGLB	(STARTGLB+NUMGLBS*SYMSIZ)
#define	STARTLOC	(ENDGLB+SYMSIZ)
#define	ENDLOC	(symtab+SYMTBSZ-SYMSIZ)

/* symbol table entry format */

#define	NAME	0
#define	IDENT	9
#define	TYPE	10
#define	STORAGE	11
#define	OFFSET	12

/* system-wide name size (for symbols) */

#define	NAMESIZE	9
#define	NAMEMAX	8

/* possible entries for "ident" */

#define	VARIABLE	1
#define	ARRAY	2
#define	POINTER	3
#define	FUNCTION	4

/* possible entries for "type" */

#define	CCHAR	1
#define	CINT	2

/* possible entries for storage */

#define	PUBLIC	1
#define	AUTO	2
#define	EXTERN	3

#define	STATIC	4
#define	LSTATIC	5
#define	DEFAUTO	6
/* "do"/"for"/"while"/"switch" statement stack */

#define	WSTABSZ	100
#define	WSSIZ	7
#define	WSMAX	ws+WSTABSZ-WSSIZ

/* entry offsets in "do"/"for"/"while"/"switch" stack */

#define	WSSYM	0
#define	WSSP	1
#define	WSTYP	2
#define	WSCASEP	3
#define	WSTEST	3
#define	WSINCR	4
#define	WSDEF	4
#define	WSBODY	5
#define	WSTAB	5
#define	WSEXIT	6

/* possible entries for "wstyp" */

#define	WSWHILE	0
#define	WSFOR	1
#define	WSDO	2
#define	WSSWITCH	3

/* "switch" label stack */

#define	SWSTSZ	100

/* literal pool */

#define	LITABSZ	2000
#define	LITMAX	LITABSZ-1

/* input line */

#define	LINESIZE	150
#define	LINEMAX	(LINESIZE-1)
#define	MPMAX	LINEMAX

/* macro (define) pool */

#define	MACQSIZE	1000
#define	MACMAX	(MACQSIZE-1)

/* "include" stack */

#define	INCLSIZ	3

/* statement types (tokens) */

#define	STIF	1
#define	STWHILE	2
#define	STRETURN	3
#define	STBREAK	4
#define	STCONT	5
#define	STASM	6
#define	STEXP	7
#define	STDO	8
#define	STFOR	9
#define	STSWITCH	10

#define	DEFLIB "./"

//define deflib inclib()

/* fixup for case code generation */

#define CASE 0
#define DEFAULT 1







/* storage words */

extern	char	symtab[];
extern	char	*glbptr, *rglbptr, *locptr;
extern	int	ws[];
extern	int	*wsptr;
extern	int	swstcase[];
extern	int	swstlab[];
extern	int	swstp;
extern	char	litq[];
extern	int	litptr;
extern	char	macq[];
extern	int	macptr;
extern	char	line[];
extern	char	mline[];
extern	int	lptr, mptr;

/* miscellaneous storage */

extern	int	nxtlab,
		litlab,
		stkp,
		argstk,
		ncmp,
		errcnt,
		glbflag,
		ctext,
		cmode,
		lastst;

extern	FILE	*input, *input2, *output;
extern	FILE	*inclstk[];
extern	int	inclsp;
extern	char	fname[];

extern	char	quote[];
extern	char	*cptr;
extern	int	*iptr;
extern	int	fexitlab;
extern	int	iflevel, skiplevel;
extern	int	errfile;
extern	int	sflag;
extern	int	cflag;
extern	int	errs;
extern	int	aflag;

extern  int     TRACE;



void inittrace(void);
void endtrace(void);
void header (void);
void nl (void);
void initmac(void);
void error (char ptr[]);
void doerror(char *ptr); 
void addwhile (int ptr[]);
void delwhile (void);
int readwhile (void);
int findwhile (void);
int readswitch (void);
void addcase (int val);
int getlabel (void);
void printlabel (int label);
void glabel (char *lab);
void gnlabel (int nlab);
int outbyte (char c);
void outstr (char ptr[]);
void tab (void);
void ol (char ptr[]);
void ot (char ptr[]);
void outdec (int number);
void store (int *lval);
void rvalue (int *lval);
void test (int label,int ft);
int openin (char *p) ;
int openout (void);
void outfname (char *s);
void fixname (char *s);
int checkname (char *s);
void kill (void);
void finline (void);
int inbyte (void);
int inchar (void);
int gch (void);
int nch (void);
int ch (void);
void pl (char *str);
void newfunc (void);
void getarg (int t);
void ns (void);
void junk (void);
int endst (void);
void needbrack (char *str);
int alpha (char c);
int numeric (char c);
int an (char c);
int sstreq (char *str1) ;
int streq (char str1[], char str2[]);
int astreq (char str1[], char str2[], int len);
int match (char *lit);
int amatch (char *lit, int len);
void blanks (void);
void declglb (int typ,int stor);
void declloc (int typ,int stclass);
int needsub (void);
int findglb (char *sname);
int findloc (char *sname);
int addglb (char *sname, char id, char typ, int value, int stor);
int addloc (char *sname, char id, char typ, int value, int stclass);
int symname (char *sname);
void illname (void);
void multidef (char *sname);
int glint(char *syment);
int primary (int *lval);
int dbltest (int val1[], int val2[]);
void result (int lval[], int lval2[]);
int constant (int val[]);
int number (int val[]);
int pstr (int val[]);
int qstr (int val[]);
int spechar(void) ;
void callfunction (char *ptr);
void needlval (void);
int statement (int func);
int stdecl (void);
int doldcls(int stclass);
void stst (void);
void compound (int func);
void doif (void);
void dowhile (void);
void dodo (void);
void dofor (void);
void doswitch (void);
void docase (void);
void dodefault (void);
void doreturn (void);
void dobreak (void);
void docont (void);
void dumpsw (int ws[]);
void doinclude (void);
int fixiname (void);
void doasm (void);
void dodefine (void);
void doundef (void);
void preprocess (void);
void doifdef (int ifdef);
int ifline(void);
void noiferr(void);
int cpp (void);
int keepch (char c);
void defmac(char *s);
void addmac (void);
void delmac(int mp)	;
int putmac (char c);
int findmac (char *sname);
void toggle (char name,int onoff);
void expression (int comma);
int heir1 (int lval[]);
int heir1a (int lval[]);
int heir1b (int lval[]);
int heir1c (int lval[]);
int heir2 (int lval[]);
int heir3 (int lval[]);
int heir4 (int lval[]);
int heir5 (int lval[]);
int heir6 (int lval[]);
int heir7 (int lval[]);
int heir8 (int lval[]);
int heir9 (int lval[]);
int heir10 (int lval[]);
int heir11 (int *lval);
int galign(int t);
int intsize(void);
int byteoff(void);
void olprfix(void);
void col (void);
void comment (void);
void prefix (void);
void trailer (void);
void prologue (void);
void gtext (void);
void gdata (void);
void ppubext(char *scptr);
void fpubext(char *scptr);
void onum(int num);
void getmem (char *sym);
void getloc (char *sym);
void putmem (char *sym);
void putstk (char typeobj);
void indirect (char typeobj);
void swap (void);
void immed (void);
void gpush (void);
void gpop (void);
void swapstk (void);
void gcall (char *sname);
void gret (void);
void callstk (void);
void jump (int label);
void testjump (int label,int ft);
void defbyte (void);
void defstorage (void);
void defword (void);
int modstk (int newstkp);
void gaslint (void);
void gasrint(void);
void gjcase(int label);
void outcase(int typ,int value,int label);
void gadd (int *lval,int *lval2);
void gsub (void);
void gmult (void);
void gdiv (void);
void gmod (void);
void gor (void);
void gxor (void);
void gand (void);
void gasr (void);
void gasl (void);
void gneg (void);
void glneg (void);
void gcom (void);
void gbool (void);
void ginc (int lval[]);
void gdec (int lval[]);
void geq (void);
void gne (void);
void glt (void);
void gle (void);
void ggt (void);
void gge (void);
void gult (void);
void gule (void);
void gugt (void);
void guge (void);
void gnargs(int d);
int assemble(char *s);
int link(void);
int main (int argc, int *argv);
void FEvers(void);
void usage(void);
void parse (void);
int dodcls(int stclass);
void dumplits (void);
void dumpglbs (void);
void errorsummary (void);
int ftypeof(char *s);
