; This module declares the variables and constants used in the examples
; It is common to all of the examples
;
; Declare Special Function Registers used
T2High		DATA	0CDH
T2Low		DATA	0CCH
T2ReloadHigh	DATA	0CBH
T2ReloadLow	DATA	0CAH
T2Control	DATA	0C8H
S0Control	DATA	098H
S0Data		DATA	099H
EI		DATA	0A8H
EIE		DATA	0E8H	; EZ-USB specific
EXIF		DATA	091H	; EZ-USB specific
EICON		DATA	0D8H	; EZ-USB specific
PageReg		DATA	092H	; EZ-USB specific, used with MOVX @Ri
DPS		DATA	086H	; EZ-USB specific, used with dual data pointers
;
; "External" memory locations used, EZ-USB specific
; Note that most of these variables are in Page 7FH
SETUPDAT	EQU	07FE8H
SUDPTR		EQU	07FD4H
EP0Control	EQU	07FB4H
EP0InBuffer	EQU	07F00H
EP0OutBuffer	EQU	07EC0H		; Not in Page 7FH
EP1Control	EQU	07FB6H
EP1InBuffer	EQU	07E80H		; Not in Page 7FH
IN0ByteCount	EQU	07FB5H
Out0ByteCount	EQU	07FC5H
IN1ByteCount	EQU	07FB7H
IN07IEN		EQU	07FACH
IN07IRQ		EQU	07FA9H
OUT07IEN	EQU	07FADH
OUT07IRQ	EQU	07FAAH
USBIEN		EQU	07FAEH
USBIRQ		EQU	07FABH
USBControl	EQU	07FD6H
I2CData		EQU	07FA6H
I2CControl	EQU	07FA5H
PortA_Config	EQU	07F93H
PortB_Config	EQU	07F94H
PortC_Config	EQU	07F95H
PortA_OUT	EQU	07F96H
PortB_OUT	EQU	07F97H
PortC_OUT	EQU	07F98H
PortA_PINS	EQU	07F99H
PortB_PINS	EQU	07F9AH
PortC_PINS	EQU	07F9BH
PortA_OE	EQU	07F9CH
PortB_OE	EQU	07F9DH
PortC_OE	EQU	07F9EH
;
; Byte Variables
		
		DSEG	AT 20H
FLAGS:		DS 	1	; This register is bit-addressable
; Bit Variables
Configured	EQU	FLAGS.0	; Is this device configured
STALL		EQU	FLAGS.1	; Need to STALL endpoint 0
SendData	EQU	FLAGS.2 ; Need to send data to PC Host
IsDescriptor	EQU	FLAGS.3	; Enable a shortcut reply
;
MonitorSpace:	DS	1FH	; Used by Dscope
Temp:		DS	1	; A temporary working register
Idle_Time:	DS	1	; The time the PC host wants us to wait
Expired_Time:	DS	1	; A downcounter for timed Reports
ReplyBuffer:	DS	3	; First byte is Count
CurrentConfiguration:
		DS	1	; Some examples support > 1 configurations
;
RBFull		EQU	FLAGS.4	; Set when the Receive Buffer is FULL
SBFull		EQU	FLAGS.5	; Set when the Send Buffer is FULL
EP1INReady	EQU	FLAGS.6	; Set when EP1 IN Ready but no characters to send
TXReady		EQU	FLAGS.7	; Set when S0 TX is ready but no character to send
USBin:		DS	1	; Head pointer into Send Buffer
SerialOUT:	DS	1	; Tail pointer into Send Buffer
SerialIN:	DS	1	; Head pointer into Receive Buffer
USBout:		DS	1	; Tail pointer into Receive Buffer
SendBuffer:	DS	20	; Buffers characters from USB for the serial port
SendBufferEnd	EQU	$
ReceiveBuffer:	DS	20	; Buffers characters from the serial port for USB
ReceiveBufferEnd EQU	$
BuffersLength	EQU	$-SendBuffer


;
