; This module declares the descriptors
;
; This example has one Device Descriptor with:
;	One Configuration - single IN port and single OUT port
;	One Interface - there is only one method of accessing the ports
;	One HID Descriptor - to make PC host software simpler
;	One Endpoint Descriptor - for HID Input Reports
;	One Report Descriptor - one byte IN and one byte OUT reports
;	Multiple Sting Descriptors - to aid the user
;
	CSEG
DeviceDescriptor:
	DB	18, 1		; Length, Type
	DW	101H		; USB Rev 1.1
	DB	0, 0, 0		; Class, Subclass and Protocol
	DB	64 		; EP0 size
	DW	4242H, 1, 1	; Vendor ID, Product ID and Version
	DB	1, 2, 0		; Manufacturer, Product & Serial# Names
	DB	1		; #Configs
ConfigurationDescriptor:
	DB	9, 2		; Length, Type
	DB	LOW(ConfigLength), HIGH(ConfigLength)
	DB	1, 1, 0		; #Interfaces, Configuration#, Config. Name
	DB	10000000b	; Attributes = Bus Powered
	DB	50		; Max. Power is 50x2 = 100mA
InterfaceDescriptor:
	DB	9, 4		; Length, Type
	DB	0, 0, 1		; No alternate setting, HID uses EP1
	DB	3		; Class = Human Interface Device
	DB	0, 0		; Subclass and Protocol
	DB	0		; Interface Name
HIDDescriptor:
	DB	9, 21H		; Length, Type
	DB	0, 1		; HID Class Specification compliance
	DB	0		; Country localization (=none)
	DB	1		; Number of descriptors to follow
	DB	22H		; And it's a Report descriptor
	DB	LOW(ReportLength), HIGH(ReportLength)
EndpointDescriptor:
	DB	7, 5		; Length, Type
	DB	10000001b	; Address = IN 1
	DB	00000011b	; Interrupt
	DB	64, 0		; Maximum packet size (this example only uses 1)
	DB	10		; Poll every 100 msec 
ConfigLength	EQU $ - ConfigurationDescriptor

ReportDescriptor:		; Generated with HID Tool, copied to here
	DB	6, 0, 0FFH	; Usage_Page (Vendor Defined)
	DB	9, 1		; Usage (I/O Device)
	DB	0A1H, 1		; Collection (Application)
	DB	19H, 1		;   Usage_Minimum 
	DB	29H, 2		;   Usage_Maximum
	DB	15H, 0		;   Logical_Minimum (0)
	DB	25H, 1		;   Logical_Maximum (1)
	DB	75H, 8		;   Report_Size (8)
	DB	95H, 1		;   Report_Count (1)
	DB	81H, 2		;   Input (Data,Var,Abs)
	DB	19H, 1		;   Usage_Minimum
	DB	29H, 2		;   Usage_Maximum
	DB	91H, 2		;   Output (Data,Var,Abs)
	DB	0C0H		; End_Collection
ReportLength	EQU $-ReportDescriptor
	 
String0:			; Declare the UNICODE strings
	DB	4, 3, 9, 4	; Only English language strings supported
String1:			; Manufacturer
	DB	(String2-String1),3 ; Length, Type 
	DB	"U",0,"S",0,"B",0," ",0,"D",0,"e",0,"s",0,"i",0,"g",0,"n",0," ", 0
	DB	"B",0,"y",0," ",0,"E",0,"x",0,"a",0,"m",0,"p",0,"l",0,"e",0
String2:			; Product Name
	DB	(EndOfDescriptors-String2),3
	DB	"S",0,"e",0,"r",0,"i",0,"a",0,"l",0,"1",0
EndOfDescriptors:
	DW	0		; Backstop for String Descriptors



