; This module initializes the microcontroller then executes MAIN forever
;
SignOnMessage:	DB 13, 13, "Serial1 V0.9", 13 	;USB Serial Device 
SignOnLength	EQU $-SignOnMessage

Reset:
	MOV	SP, #235		; Initialize the Stack
	MOV	PageReg, #7FH		; Allows MOVX Ri to access EZ-USB memory

	MOV	R0, #Low(USBControl)	; Simulate a disconnect
	MOVX	A, @R0
	ANL	A, #11110011b		; Clear DISCON, DISCOE
	MOVX	@R0, A
	CALL	Wait100msec   		; Give the host time to react
	MOVX	A, @R0			; Reconnect with this new identity
	ORL	A, #00000110b           ; Set DISCOE to enable pullup resistor
	MOVX	@R0, A	 		; Set RENUM so that 8051 handles USB requests
	CLR	A
	MOV	FLAGS, A		; Start in Default state
InitializeVariables:
	MOV	R0, #SendBuffer
	MOV	R7, BuffersLength
IVLoop:	MOV	@R0, A			; Clear Send and Receive Buffers
	INC	R0
	DJNZ	R7, IVLoop

	MOV	DPTR, #SignOnMessage	; Put a Signon in the Receive Buffer
	MOV	R7, #SignonLength
	MOV	R0, #ReceiveBuffer
IVLoop2:MOVX	A, @DPTR
	MOV	@R0, A
	INC	DPTR
	INC	R0
	DJNZ	R7, IVLoop2
	MOV	SerialIN, R0
	MOV	USBout, #ReceiveBuffer
	MOV	SerialOUT, #SendBuffer
	MOV	USBin, #SendBuffer


InitializeIOSystem:			; Work around the Dscope monitor I/O needs
; Use Serial 0 since dScope has Serial 1
	MOV	A, #0FFH		; Set up Timer 2 as a baud rate generator
	MOV	T2High, A
	MOV	T2Low, A
	MOV	T2ReloadHigh, A
	MOV	A, #0D9H		; 19.2Kb
	MOV	T2ReloadLow, A
	MOV	A, #00110100b
	MOV	T2Control, A		; Start Timer 2
	MOV	A, #01010000b		; Set up Serial 0 as 1 start, 8 data, 1 stop
	MOV	S0Control, A

InitializeInterruptSystem:		; First initialize the USB level 
	MOV	A, #00000000b
	MOV	R0, #LOW(IN07IEN)
	MOVX	@R0, A			; Enable EP1 IN Endpoints only
	CLR	A
	INC	R0
	MOVX	@R0, A			; Disable interrupts from OUT Endpoints 0-7
	INC	R0
	MOV	A, #00000011b
	MOVX	@R0, A			; Enable (Resume, Suspend,) SOF and SUDAV INTs
	INC	R0
	MOV	A, #00000001b
	MOVX	@R0, A			; Enable Auto Vectoring for USB interrupts

	MOV	R0, #LOW(EP1Control)	; Clear any stale information from ...
	MOV	A, #00000010b		; ... EP1 IN buffer
	MOVX	@R0, A
	                                ; Now enable the main level
	MOV	EIE, #00000001b		; Enable INT2 = USB Interrupt (only) 		
        MOV	EI, #11010000b		; Enable Serial0 interrupt (and Ser1 for dScope)
 
; Initialization Complete.
; 
MAIN:
	NOP				; Not much of a main loop for this example
	JMP	MAIN			; All actions are initiated by interrupts
; We are a slave, we wait to be told what to do

Wait100msec:
	MOV	Temp, #100
Wait1msec:				; A delay loop
	MOV	DPTR, #-1200		
More:	INC	DPTR			; 3 cycles
	MOV	A, DPL                  ; + 2
	ORL	A, DPH                  ; + 2
	JNZ	More                    ; + 3 = 10 cycles x 1200 = 1msec
	DJNZ	Temp, Wait1msec
	RET


