//
// Pre-processor for TeX4ht, allowing for files which may or may not
// contain an explicit reference to the system package.
// Syntax: HTRUN filename [-optional translation prefix] [other options for TeX4ht] 
//
// Return codes: 0 = normal completion
//               1 = ini file not found
//               2 = could not open source file
//               3 = could not find batch file
//
// By Phil Viton, (viton.1@osu.edu), March 2000
// Acknowledgements: Steve Mayer provided valuable suggestions and served as a willing
// guinea-pig while htrun was being developed. Eitan Gurari not only examine versions 
// of the code _twice_, resulting in numerous substantive and organizational improvements,
// but also provided the main idea for the handling of additional translation
// types (now incorporated via the batch file prefix TRANSTYPE)
// To both, sincere thanks. All remaining bugs are of course mine.                
//
//
// March 25, 2000: revised according to Eitan Gurari's suggestions
// April 4: logic for swp revised to take care of the case where the order is
//            \input{tcilatex}   \RequirePackage{swpht}
//            we now wait untel we see \begin{document} to decide what to do
// April 6: added ability to distinguish latex2e from latex209 files. This is
//            needed by the truetex compiler, which balks at the very long
//            command line offered by htlatex.bat, under w98 (win nt is fine)
//            This is governed by the integer constant LATEX209, and if this is 1
//            we execute (defaults) htlatex2em.bat and htlatex209m.bat
//          Added integer LATEXCOUNT: this is added to nquote when processing
//            plain latex files, to allow one to switch between miktex style, in which
//            arg 2 is a parameter to tex4ht, and swp style in which it's the
//            number of latex passes. 
//          The debug section of the ini file is now renamed "integers"
// April 8: fixed serious bug regarding the .ini file: this was being found
//            only when it happened to be in the current directory. 
//            We now search for it along your path.
//          Added PAUSE, which allows you to pause before executing the batch file
// April 9: changed the info message printed when you call the system with no args:
//            we now print most of the debug info. (This, and slightly more, is also
//            printed when DEBFLAG=1). We now include the compile date and time.
//          added PACKQUOTE to allow an empty arg to the package to be expanded
//            from "" to " " : this is currently needed for MiKTeX, but not for truetex.
//            default = 0 (off).
// April 13: minor cleanups, thanks to Steve Mayer; removed a section of code
//           at the end of the main recognition loop dealind with PLAINTEX, since
//           we never actaully set this variable any more (so the if always failed).
// April 14: default batch behavior is changed: if the ini does not specify a batch
//           file, we now execute the file named in NOBATCHNAME 
//           (default = dNOBATCHNAME = htrun_no.bat).  Since this will typically be
//           a non-existent file, this makes it easier to  spot typos in the inifile 
//           (in the sense that now your batch file won't run) 
//           The identifier strings for batch files have also changed, to be 
//           more mnemonic and descriptive.  
// April 15: return code 2 when tex file is not opened (was 1, we can now distinguish this
//           event from the case of the ini file not being found).  
// April 16: if PAUSE is on, you can reply with N (or n) and stop the job from running
// April 19: we allow the user to speicify a switch, prefaced by - : the rest of
//           this argument (if any) is taken as a prefix TRANSTYPE, which is 
//           prepended to the name of the batch file to be executed. Default is "ht"
//           for html translation.  THE ESSENTIAL IDEA HERE IS DUE TO EITAN GURARI.
// April 22: removed call to "toupper" which was causing problems: I hadn't included
//           the ctype.h header, but the mingw32 compiler reported no errors. The
//           program ran on nt, but crashed on w98. Thanks to Steve Mayer for this
//           one. 
// April 24: at Steve Mayer's suggestion, changed the text of the message
//           printed when PAUSE is on, to remind users they can press n to quit. 
// April 28: at Steve Mayer's suggestion, added a graceful exit if the batch file
//           is not found in your path. This means you will no longer get a 
//           cryptic message when we try to run a non-existent batch file.
//           New return code = 3 indicates that this problem arose. 
//           This means that the ntrun_no.bat setup isn't useful any longer,
//           except as a way of indicating typos on the info screen (that
//           batch file will never be executed).  So I've replaced it by
//           "???????" (which will get a prefix).
//           Now using mingw compile 2.95.2 
//
//
// Logic: read through the document:
//                                                                  And run batch file named
//                                                                  in variable (with prefix
//    If we find: (=default)        We conclude that file is:        TRANSTYPE prepenmded):
//   =======================       ==============================   ==================
//   \begin{document}  and           
//     SWPPACK={swpht} (*)         SWP LaTeX file with package      SWPPACKNAME
//     T4PACK={tex4ht} (*)         Ordinary LaTeX with package      LATEXPACKNAME
//     SWPINPUT=tcilatex (**)      SWP LaTeX file w/o package       SWPNAME
//     (none of the above)         Ordinary LaTeX file w/o package  LATEXNAME 
//   TEXIINPUT=texinfo (**) 
//     or extension TEXI/texi      TeXInfo file                     TEXINAME
//   CSNAME=tex4ht\endcsname (***) Plain-TeX                        PLAINNAME
//   (*): braces required    (**) : using \input 
//   (***): must be entered exactly  as shown : no extraneous spaces.
//
//   Otherwise this is a plain TeX file w/o CSNAME: report an error and quit.
//   We do not support plain TeX via the old ht.bat file
//
//   The default batch file --- which should be non-existent unless you want to
//   so something clever -- can be set via NoBatchName in the [files] section
//   Note that it will also get TRANSTYPE prepended
//   NB: strings (first col) are specified in the [strings] section of the .ini file
//       batch files (3rd col) are in the [files] section
//
//  Note: in this program, the batch file name identifiers are all uppercase 
//  (C is case sensitive) but in the ini file, you can use any combination of 
//  upper- and  lower-case. 
//
//  
// Switches in the [integers] section of the .ini file
//              DEBFLAG = 1 prints additonal debug info to your screen (default = 0)
//             RDEBFLAG = 1 does not actually run the selected batch file, so you can see
//                           what ^would^ be done wothout wasting time on an execution.
//             LATEX209 = 1 allows you to execute different batch files for LaTeX 2e and 209
//                          files (default = 0)  In this case we run
//                           LATEX209NAME for a latex209 document
//                           LATEX2eNAME for a latex2e document  
//                          This is useful only when your TeX compiler doesn't like the
//                          very long string in LATEXNAME, and is needed for
//                          truetex under win98 but not for miktex.
//           LATEXCOUNT = 1 allows you to specify parameter 2 of a batch file as the number
//                          of latex passes, ie it is an unquoted argument. (default = 0)   
//                PAUSE = 1 allows you to pause before executing the batch file: this may
//                          be useful in non-windowed TeX compilers like MikTeX. (default=0)
//                          A response of N or n aborts
//            PACKQUOTE = 1 expands an empty ("") option for the TeX4ht package to " "
//                          (ie with an extra space). Currently required for MikTeX at
//                          least under winnt4. Not needed for truetex
//
// Note on arguments: in general we just pass through to the batch files
// whatever you provide. It's up to you to make sure that invalid arguments are
// rejected or ignored by the batch files. 
//
// Windows-specific functions used:
//     _fullpath : make filename into full path
//     _splitpath : split a _fullpath into its component parts 
//     GetPrivateProfileString: handle the .ini file 

#include<stdio.h>
#include<string.h>
#include<conio.h>
#include<windows.h>
#include<ctype.h>

                                          // RECOGNITION OF SOURCE DOCUMENT defaults:
                                          // (values in the .ini file will override these)
#define dSWPPACK "{swpht}"                // name of swp package
#define dT4PACK "{tex4ht}"                // name of ordinary latex package
#define dSWPINPUT "tcilatex"              // signature of an swp file used, with \input
#define dTEXIINPUT "texinfo"              // signature of a TeXINFO file, used with \input
#define dCSNAME "tex4ht\\endcsname"       // required for plain tex or TeXInfo

#define dNOBATCHNAME "??????"             // this will show up on the info scrren if a batch
                                          // file isn't (properly) specified in the ini file

#define TEXEXT ".tex"                     // default extesnion if user doesn;'t specify
#define TEXIEXT1 ".texi"                  // this identifies a TeXinfo file
#define TEXIEXT2 ".TEXI"                  // this does too
#define BLANK " "
#define DQUOTE "\"\""
#define QUOTE "\""
#define BEGIN "\\begin"                   // signature of a latex file, part1
#define DOCUMENT "document"               // signature of a LaTeX file, part deux
#define INPUT "\\input"                   // macro name for file input
#define DOCCLASS "\\documentclass"        // signature of a LaTeX2e file
#define DOCSTYLE "\\documentstyle"        // signature of a LaTeX209 file 

#define MV1 250
#define MV2 100
#define MV3 300

char NILL;


int cmdline(WORD PACKQUOTE, WORD PAUSE, WORD RDEBFLAG, int nquote, char *cmd1, int argc, char *argv[], char *TRANSTYPE);

int macrocheck(char *buff, char *MACRONAME, char *MACROARG);

int main(int argc, char *argv[])
{
 char buff[MV1],fname[MV1],cmd1[MV1];
 int len,nquote;
 int swpinput,swppack,latex209;
 int j,k;
 FILE *fp;

char path[MV1];
char drive[MV1];
char dir[MV1];
char filname[MV1];
char ext[MV1];
char ininame[MV3];
                                         
char SWPPACK[MV2],T4PACK[MV2],SWPINPUT[MV2],TEXIINPUT[MV2],CSNAME[MV2];                                     
char SWPPACKNAME[MV2],SWPNAME[MV2],LATEXPACKNAME[MV2],LATEXNAME[MV2],TEXINAME[MV2],PLAINNAME[MV2];
char LATEX209NAME[MV2],LATEX2ENAME[MV2],NOBATCHNAME[MV2];
char inipath[MV3];
char TRANSTYPE[MV3]="ht";

WORD DEBFLAG,RDEBFLAG,LATEX209,LATEXCOUNT,PAUSE,PACKQUOTE;


// ***************** PARSE THE COMMAND LINE, LOOKING FOR THE SWITCH *****************
// the switch must be in position 1, BEFORE THE FILE NAME
// at the end of this loop, the TRANSTYPE switch (if present) has been removed
// from the command line.
   if ((argc >= 2) && (argv[1][0]=='-') )
     { 
       k = strlen(argv[1]);
       for (j = 1; j <= k; j++){TRANSTYPE[j-1]=argv[1][j];}
       TRANSTYPE[j+1]=NILL;
       for (j = 2 ; j < argc ; j++) {argv[j-1]=argv[j];}
       argc = argc - 1; 
     }


// **************THIS SECTION HANDLES THE INITIALIZATION via an ini file *****************
// the ini file must be in the path (or in the current directory)
_fullpath(path,argv[0],250);
_splitpath(path,drive,dir,filname,ext);
strcpy(ininame,filname);
strcat(ininame,".ini");
// now look for it
_searchenv(ininame,"PATH",inipath);
if(inipath[0] == NILL)
 {
   printf("Could not find .ini file - quitting with return code 1\n");
   exit(1);
  }
strcpy(ininame,inipath);

// now get the data from the .ini file, beginning with the batch files 
// NOTE THAT IT'S IMPOTANT THAT WE GET NOBATCHNAME first, since it's the default for all others
GetPrivateProfileString("Files", "NOBATCHNAME", dNOBATCHNAME, NOBATCHNAME, MV2, ininame);
GetPrivateProfileString("Files", "SWPPACKNAME",NOBATCHNAME, SWPPACKNAME, MV2, ininame);
GetPrivateProfileString("Files", "SWPNAME", NOBATCHNAME, SWPNAME, MV2, ininame);
GetPrivateProfileString("Files", "LATEXPACKNAME", NOBATCHNAME, LATEXPACKNAME, MV2, ininame);
GetPrivateProfileString("Files", "LATEXNAME", NOBATCHNAME,LATEXNAME, MV2, ininame);
GetPrivateProfileString("Files", "TEXINAME", NOBATCHNAME, TEXINAME, MV2, ininame);
GetPrivateProfileString("Files", "PLAINNAME", NOBATCHNAME, PLAINNAME, MV2, ininame);
GetPrivateProfileString("Files", "LATEX2ENAME", NOBATCHNAME,LATEX2ENAME, MV2, ininame);
GetPrivateProfileString("Files", "LATEX209NAME", NOBATCHNAME,LATEX209NAME, MV2, ininame);

// Now the recognition strings
GetPrivateProfileString("Strings", "SWPPACK", dSWPPACK, SWPPACK, MV2, ininame);
GetPrivateProfileString("Strings", "T4PACK", dT4PACK, T4PACK, MV2, ininame);
GetPrivateProfileString("Strings", "SWPINPUT", dSWPINPUT, SWPINPUT, MV2, ininame);
GetPrivateProfileString("Strings", "TEXIINPUT", dTEXIINPUT, TEXIINPUT, MV2, ininame);
GetPrivateProfileString("Strings", "CSNAME", dCSNAME, CSNAME, MV2, ininame);

// Lastly, the flags and other integer variables
DEBFLAG=GetPrivateProfileInt("integers", "DEBFLAG",0, ininame);   
RDEBFLAG=GetPrivateProfileInt("integers", "RDEBFLAG",0, ininame); 
LATEX209=GetPrivateProfileInt("integers", "LATEX209",0, ininame);
LATEXCOUNT=GetPrivateProfileInt("integers", "LATEXCOUNT",0, ininame);
PAUSE = GetPrivateProfileInt("integers", "PAUSE",0, ininame);
PACKQUOTE = GetPrivateProfileInt("integers", "PACKQUOTE",0, ininame);



// ***************************** USER FEEDBACK **********************************


// If user provided no arguments,- print an explanation and exit, while if DEBFLAG = 1 
// print the explanation and continue
if ((argc==1) || (DEBFLAG ==1))
 {
   printf("\nHTRUN - Cover function for the Tex4ht system: %s : %s\n", __DATE__, __TIME__);
   printf("Syntax: htrun [-translation prefix] filename [other options]\n");
   printf("\nRDEBFLAG = %d,",RDEBFLAG);
   if (RDEBFLAG==1) {printf(" so we shall not actually run the batch file\n");}
   if (RDEBFLAG==0) {printf(" so we shall run the batch file\n");}
   printf("LATEX209 = %d,",LATEX209);
   if (LATEX209==0){printf(" so we do not distinguish between LaTeX2e and LaTeX2.09\n");}
   if (LATEX209==1){printf(" so we distinguish between LaTeX2e and LaTeX2.09\n");}
   printf("LATEXCOUNT = %d,",LATEXCOUNT);
   if (LATEXCOUNT==0){printf(" so argument 2 will be quoted\n");}  
   if (LATEXCOUNT==1){printf(" so argument 2 will not be quoted\n");}
   printf("PACKQUOTE = %d,",PACKQUOTE);
   if (PACKQUOTE==0){printf(" so we will not expand an empty arg to the TeX4ht package\n");}  
   if (PACKQUOTE==1){printf(" so we will expand an empty arg to the TeX4ht package\n");} 
   printf("Using .ini file at: %s\n",ininame); 
   printf("\n");
   printf("\n");
   printf("Case                           Batch File      Recognition string(s)\n");
   printf("SWP, explicit package:         %s%-11s   %s (*) \n",TRANSTYPE,SWPPACKNAME,SWPPACK);
   printf("SWP, no explicit package:      %s%-11s   %s (**) \n",TRANSTYPE,SWPNAME,SWPINPUT);
   printf("LaTeX, explicit package:       %s%-11s   %s (*) \n",TRANSTYPE,LATEXPACKNAME,T4PACK);
   if (LATEX209==0)
     {printf("LaTeX, no explicit package:    %s%-11s   %s{%s} (***) \n",TRANSTYPE,LATEXNAME,BEGIN,DOCUMENT);}
   if (LATEX209==1)
     {
       printf("LaTeX2e, no explicit package:  %s%-12s  %s{%s} %s \n",TRANSTYPE,LATEX2ENAME,BEGIN,DOCUMENT,DOCCLASS);
       printf("LaTeX209, no explicit package: %s%-12s %s{%s} %s\n",TRANSTYPE,LATEX209NAME,BEGIN,DOCUMENT,DOCSTYLE);
     }
   printf("TeXinfo:                       %s%-11s   %s (**) or extension .texi\n",TRANSTYPE,TEXINAME,TEXIINPUT );     
   printf("Otherwise, Plain-TeX:          %s%-11s   %s (****) \n",TRANSTYPE,PLAINNAME,CSNAME);
   printf("(*) : braces required    (**): handled via \\input   (***): not user-changeable\n");
   printf("(****): must match EXACTLY, in case and without blanks\n");

   if (argc==1) exit(0);
 }


// ****************** OK, WE WANT TO DO A TRANSLATION ************************

// did the user provide an extension for the source file?
// if not, use TEXEXT=.tex; note that we use this only to open the file: 
// in the batch files, we use only what was provided on the command line.
strcpy(fname,argv[1]);
_fullpath(path,argv[1],MV1);
_splitpath(path,drive,dir,filname,ext);

// if the extension was .texi or .TEXI we're done
if ((strstr(ext,TEXIEXT1) != NULL) || (strstr(ext,TEXIEXT2) != NULL))
  {
   printf("\nHTRUN - %s is a TeXINFO file\n",fname);
   fp = fopen(fname, "r");
   if (fp == NULL)
     {
       printf("\nHTRUN - We could not open %s - quitting with return code 1\n",fname);
       exit(2);
     }
   nquote = 1+LATEXCOUNT;
   strcpy(cmd1, TEXINAME);
   cmdline(PACKQUOTE,PAUSE,RDEBFLAG,nquote,cmd1,argc,argv,TRANSTYPE); 
   exit(0);
  }

len=strlen(ext);
if(len==0) 
  {
    strcat(fname,TEXEXT);
    if (DEBFLAG) {printf("\nNo source-file extension provided - using %s\n",TEXEXT);}
  }
if (DEBFLAG) {printf("We shall try to open the file %s\n",fname);}

fp=fopen(fname, "r");      
if (fp == NULL) 
  {
    printf("\nHTRUN - We could not open %s - quitting with return code 1\n",fname);
    exit(2);
  }

// set up two flags for swp 
swpinput = 0;
swppack = 0;
// and one for the type of latex document (will be used only if LATEXFLAG=1) default is latex2e
latex209= 0 ;

// Now let's read the file and see what we've got
while (fgets(buff,245,fp)!=NULL)
{  
   if (buff[0]=='%') continue ;             

   if (strstr(buff,DOCSTYLE) != NULL) latex209 = 1;

   if (strstr(buff,BEGIN) != NULL)
// retcode =  
     {if ((macrocheck(buff,BEGIN,DOCUMENT)))
          { 
            if (swppack == 1)
              {
                 printf("\nHTRUN -  %s is a LaTeX file with the TeX4ht/SWP package\n",fname);
                 nquote = 1+LATEXCOUNT;
                 strcpy(cmd1, SWPPACKNAME);  
                 cmdline(PACKQUOTE,PAUSE,RDEBFLAG,nquote,cmd1,argc,argv,TRANSTYPE); 
                 exit(0);
              }
            else if (swpinput == 1)
              {
                printf("\nHTRUN - %s is an SWP file with no TeX4ht/SWP package\n",fname);
                nquote = 1+LATEXCOUNT;
                strcpy(cmd1, SWPNAME);
                cmdline(PACKQUOTE,PAUSE,RDEBFLAG,nquote,cmd1,argc,argv,TRANSTYPE); 
                exit(0);
              }
            else if (LATEX209 == 0)
               {
                 printf("\nHTRUN - %s is a LaTeX file with no TeX4ht package\n",fname);
                 nquote = 1+LATEXCOUNT;
                 strcpy(cmd1,LATEXNAME);
                 cmdline(PACKQUOTE,PAUSE,RDEBFLAG,nquote,cmd1,argc,argv,TRANSTYPE); 
                 exit(0);
                }
            else if ((LATEX209 == 1) && (latex209==1)) 
                {
                  printf("\nHTRUN - %s is a LaTeX2.09 file with no TeX4ht package\n",fname);
                  nquote = 1+LATEXCOUNT;
                  strcpy(cmd1,LATEX209NAME);
                  cmdline(PACKQUOTE,PAUSE,RDEBFLAG,nquote,cmd1,argc,argv,TRANSTYPE); 
                  exit(0);
                 }
            else if ((LATEX209 == 1) && (latex209==0))
                 {
                   printf("\nHTRUN - %s is a LaTeX2e file with no TeX4ht package\n",fname);
                   nquote = 1+LATEXCOUNT;
                   strcpy(cmd1,LATEX2ENAME);
                   cmdline(PACKQUOTE,PAUSE,RDEBFLAG,nquote,cmd1,argc,argv,TRANSTYPE); 
                   exit(0);
                  }
          }
     }

   if (strstr(buff,SWPPACK) != NULL) {swppack=1;}
       
   if (strstr(buff,T4PACK) != NULL) 
     {
       printf("\nHTRUN - %s is a LaTeX file with the TeX4ht package\n",fname);
       nquote = 1+LATEXCOUNT;
       strcpy(cmd1, LATEXPACKNAME); 
       cmdline(PACKQUOTE,PAUSE,RDEBFLAG,nquote,cmd1,argc,argv,TRANSTYPE); 
       exit(0);
     }

   if (strstr(buff,CSNAME) != NULL) 
     {
       printf("\nHTRUN - %s is a Plain-TeX file\n",fname);
       nquote = 1+LATEXCOUNT;
       strcpy(cmd1, PLAINNAME);
       cmdline(PACKQUOTE,PAUSE,RDEBFLAG,nquote,cmd1,argc,argv,TRANSTYPE); 
       exit(0);
     }


   if ((strstr(buff,INPUT) != NULL))    
     {
       if ((macrocheck(buff,INPUT,SWPINPUT))){swpinput = 1;}
// retcode = on lines above and below
       if ((macrocheck(buff,INPUT,TEXIINPUT)))
         {
           printf("\nHTRUN - %s is a TeXinfo file\n",fname);
           nquote = 1+LATEXCOUNT;
           strcpy(cmd1, TEXINAME);
           cmdline(PACKQUOTE,PAUSE,RDEBFLAG,nquote,cmd1,argc,argv,TRANSTYPE); 
           exit(0);
         }

     }

}



// we're at the end of the file and we've not found CSNAME
printf("\nHTRUN - %s appears to be a plain-TeX file, but you need to include\n",fname);
printf("        \\csname %s  to make it usable by TeX4ht - quitting\n", CSNAME);
//exit(0);
return(0);
}


// This routine processes the rest of the command line after we've decided which 
// batch file to use and then executes the requested command 
// (whose name is prefixed by TRANSTYPE) if RDEBFLAG is 0
int cmdline(WORD PACKQUOTE, WORD PAUSE, WORD RDEBFLAG, int nquote, char *cmd1, int argc, char *argv[], char *TRANSTYPE)
{
int i,j,len;
char cmd2[400];
char cmdpath[400];
   j = nquote;
   strcpy(cmd2,TRANSTYPE);
   strcat(cmd2,cmd1);
//
// at this point we know the name of the file we wish to run. Now check that it exists
//
_searchenv(cmd2,"PATH",cmdpath);
if(cmdpath[0] == NILL)
 {
   printf("Could not find the batch file %s - quitting with return code 3\n",cmd2);
   exit(3);
  }


   if((argc-1) < nquote) j = argc-1;
//   printf("Nargs = %d     nquote = %d   loop from  1 to j =  %d\n",argc,nquote,j);
   for(i=1; i <= j ; i++)
    {strcat(cmd2,BLANK);
     strcat(cmd2,argv[i]); 
    }
   for (i=1+nquote; i < argc; i++)
     { 
       len = strlen(argv[i]);
       if (len == 0) 
        {
           if ((i==1+nquote) && (PACKQUOTE==1))
             {
               strcat(cmd2, BLANK);
               strcat(cmd2, QUOTE);
               strcat(cmd2, BLANK);
               strcat(cmd2, QUOTE);
             }
           else
             {
               strcat(cmd2,BLANK);
               strcat(cmd2,DQUOTE);
             }
        }
       if (len != 0) 
         {
          strcat(cmd2,BLANK);
          strcat(cmd2,QUOTE);
          strcat(cmd2,argv[i]);
          strcat(cmd2,QUOTE);
         }
     }
   printf("We will now run: %s\n",cmd2);
   if (RDEBFLAG == 0)
    {
      if (PAUSE == 1)
        {
          printf("Press n to quit or any other key to continue ... ");
          fflush(stdout);
//          while (! kbhit());
//          ;
          i = getch();
          if (i == 0) i = getch(); // get it again if user pressed a fn or cursor moving key
          if ((i == 'N') || (i == 'n'))
            {printf("\nExiting at your request\n");exit(0);}  
          else {printf("\n");}
        }
     system(cmd2);
    }
return(0);
}


// This routine parses a line containing MACRONAME (eg "\input") and one other string, 
// MACROARG (eg "tcilatex"). 
// We return 1 if we find  
//    MACRONAME [0 or more blanks or {] MACROARG [blank or } or EOL], which means we're legal
// and 0 otherwise
// 
// 
int macrocheck(char *buff, char *MACRONAME, char *MACROARG)
{
char LBRACE = '{';
char RBRACE = '}';
char SPACE = ' ';
char EOL = 10;
int pos1,pos2,len1,len2,i;
char *ptr1, *ptr2;

if (strstr(buff,MACROARG)==NULL){return(0);}

len1=strlen(MACRONAME);
len2=strlen(MACROARG);

ptr1=strstr(buff,MACRONAME);
pos1=ptr1-buff;
ptr2=strstr(buff,MACROARG);
pos2=ptr2-buff;

// check that chr following MACRONAME is either blank or } or \n
i = len2+ptr2-buff;
if ( (buff[i] != RBRACE) && (buff[i] != SPACE) && (buff[i] != EOL)){return(0);}

for( i=len1+pos1 ; i < pos2-pos1 ; i++)
if((buff[i] != LBRACE) && (buff[i] != SPACE)){return(0);}
// if we get here, we're legal
return(1);

}




