//
// unix2win.cpp - Translate unix format \n into windows standard
//                 
//   (c) 1999, Niko (Gargan) Berger <gargan@email.com>
//    
// Note: The main purpose was to have a program that converts
//    UNIX->WINDOWS while keeping the long filenames
//
// Compile: Compile this in Win32 console mode (using f.e. VC++, or BC)
//
// You can freely change the code and adopt it to your needs
// 

#include <windows.h>
#include <stdio.h>
#include <string.h>

void main (int argc, char *argv[])
{
   char from[200], to[200];
   bool replace = false;
   if (argc<2)
   {
      printf ("Usage: unix2win [-r joker] [FILEFROM [FILETO]]\n  option can be:\n");
      printf ("    -r ... replace all files, with this option \n    jokers are allowed\n(c) Niko (Gargan) Berger <gargan@email.com>");
      return;
   }

   if (argv[1][0] == '-')
   {
      if (argv[1][1] != 'r')
      {
         printf ("Unrecognized command. Aborting!\n");
         return;
      }

      strcpy (from, argv[2]);
      replace = true;
   }
   else
   {
      strcpy (from, argv[1]);
      if (argc<3)
         to[0] = '\0'; // output to stdout
      else
          strcpy (to, argv[2]);
   }

   HANDLE hFile;
   DWORD NumWritten;
   BY_HANDLE_FILE_INFORMATION fi;
   unsigned char *fbuf;
   register int i;
   char n = 13;

   if (!replace) // standard mode (no jokers)
   {
      hFile = CreateFile (from, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING,
                          FILE_ATTRIBUTE_NORMAL, NULL);                                  
      if (hFile == INVALID_HANDLE_VALUE)
      {
         printf ("Problem while opening %s\n", from);
         return;
      }
      GetFileInformationByHandle (hFile, &fi);

      fbuf = (unsigned char *)malloc (fi.nFileSizeLow + 1);
      ReadFile (hFile, (unsigned char *)fbuf, fi.nFileSizeLow, &NumWritten, 0);
      CloseHandle (hFile);

      if (to[0] == '\0') // just display the file
      {
         for (i = 0; i < fi.nFileSizeLow; i++)
            printf ("%c", fbuf[i]);

         free (fbuf);      
         return;
      }

      hFile = CreateFile (to, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS,
                          FILE_ATTRIBUTE_NORMAL, NULL);
      if (hFile == INVALID_HANDLE_VALUE)
      {
         printf ("Problem while opening %s\n", to);
         free (fbuf);      
         return;
      }

      for (i = 0; i < fi.nFileSizeLow; i++)
      {
         if (fbuf[i] == 10 && i == 0)
             WriteFile (hFile, &n, sizeof (n), &NumWritten, 0);

         if (fbuf[i] == 10 && i > 0)
            if (fbuf[i-1] != 13)
             WriteFile (hFile, &n, sizeof (n), &NumWritten, 0);
         WriteFile (hFile, &fbuf[i], sizeof (fbuf[i]), &NumWritten, 0);
      }

      free (fbuf);      
      CloseHandle (hFile);
   }
   else
   {
      // start looking throught the files
      WIN32_FIND_DATA fd;
      HANDLE fh;
   
      fh = FindFirstFile (from, &fd);
      if (fh == INVALID_HANDLE_VALUE)
      {
         printf ("No file found!\n");
         return;
      }

      lstrcpy (to, fd.cFileName);

      while (FindNextFile (fh, &fd))
      {
         hFile = CreateFile (to, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING,
                             FILE_ATTRIBUTE_NORMAL, NULL);                                  
         if (hFile == INVALID_HANDLE_VALUE)
         {
            printf ("Problem while opening %s\n", to);
            FindClose (fh);
            return;
         }
         GetFileInformationByHandle (hFile, &fi);

         fbuf = (unsigned char *)malloc (fi.nFileSizeLow + 1);
         ReadFile (hFile, (unsigned char *)fbuf, fi.nFileSizeLow, &NumWritten, 0);
         CloseHandle (hFile);

         hFile = CreateFile (to, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS,
                             FILE_ATTRIBUTE_NORMAL, NULL);
         if (hFile == INVALID_HANDLE_VALUE)
         {
            printf ("Problem while opening %s\n", to);
            FindClose (fh);
            free (fbuf);      
            return;
         }

         for (i = 0; i < fi.nFileSizeLow; i++)
         {
            if (fbuf[i] == 10 && i == 0)
                WriteFile (hFile, &n, sizeof (n), &NumWritten, 0);

            if (fbuf[i] == 10 && i > 0)
               if (fbuf[i-1] != 13)
                WriteFile (hFile, &n, sizeof (n), &NumWritten, 0);
            WriteFile (hFile, &fbuf[i], sizeof (fbuf[i]), &NumWritten, 0);
         }

         free (fbuf);      
         CloseHandle (hFile);

         lstrcpy (to, fd.cFileName);
      }

      FindClose (fh);
   }
}